% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/installPackage.R
\name{installPackage}
\alias{installPackage}
\alias{installPackage,ANY,ANY,character-method}
\alias{installPackage,ANY,ANY,missingOrNULL-method}
\alias{installPackage,ANY,ANY,Session-method}
\title{Adds package to SyncroSim Installation}
\usage{
installPackage(packages, versions = NULL, session = NULL)

\S4method{installPackage}{ANY,ANY,character}(packages, versions = NULL, session = NULL)

\S4method{installPackage}{ANY,ANY,missingOrNULL}(packages, versions = NULL, session = NULL)

\S4method{installPackage}{ANY,ANY,Session}(packages, versions = NULL, session = NULL)
}
\arguments{
\item{packages}{character string. The name or file path of the package to
install}

\item{versions}{character string. The packages version(s) to install if
installing a package from the server. If \code{NULL} then installs the
latest version}

\item{session}{\code{\link{Session}} object. If \code{NULL} (default),
\code{session()} will be used}
}
\value{
Invisibly returns \code{TRUE} upon success (i.e.successful
install) and \code{FALSE} upon failure.
}
\description{
This function installs a package to the SyncroSim \code{\link{Session}}.
If only the package name is provided as input, the function queries the
SyncroSim package server for the specified package. If a file path is
provided as input, the function installs a package to SyncroSim from a local
package file (ends in ".ssimpkg"). The list of SyncroSim packages can be
found \href{https://syncrosim.com/packages/}{here}.
}
\examples{
\dontrun{
# Create a new SyncroSim Session
mySession <- session()

# Install package from the package server
installPackage(packages="stsim", versions="4.0.1", session = mySession)

# Install package using a local file path
installPackage("c:/path/to/stsim.ssimpkg")
}

}
