% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breakpoint.R
\name{breakpoint}
\alias{breakpoint}
\alias{breakpoint,Scenario-method}
\title{Breakpoints for a Scenario}
\usage{
breakpoint(x)

\S4method{breakpoint}{Scenario}(x)
}
\arguments{
\item{x}{\code{\link{Scenario}} object}
}
\value{
None
}
\description{
Lists the breakpoints for a Scenario.
}
\examples{
\dontrun{
# Create callback function
callbackFunction <- function(x, iteration, timestep) {
  print(paste0("Breakpoint hit: ", scenarioId(x)))
}

# Install helloworldSpatial package
addPackage("helloworldSpatial")

# Set SsimLibrary name
myLibraryName <- file.path(tempdir(),"testlib")

# Set Session and SsimLibrary
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName,
                         session = mySession,
                         package = "helloworldSpatial")
myScenario <- scenario(myLibrary, "My Scenario")

# Add breakpoints before the 1st and 2nd iterations
myScenario <- addBreakpoint(x= myScenario,
                            transformerName= "helloworldSpatial_Primary",
                            breakpointType = "bi", 
                            arguments = c(1,2),
                            callback = callbackFunction)
                            
# Check that the breakpoints were added
breakpoint(myScenario)

# Delete breakpoints
myScenario <- deleteBreakpoint(myScenario)

# Check that breakpoints were deleted
breakpoint(myScenario)
}

}
