% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup.R
\name{backup}
\alias{backup}
\alias{backup,character-method}
\alias{backup,SsimObject-method}
\title{Backup a SsimLibrary}
\usage{
backup(ssimObject)

\S4method{backup}{character}(ssimObject)

\S4method{backup}{SsimObject}(ssimObject)
}
\arguments{
\item{ssimObject}{\code{\link{SsimLibrary}}, 
\code{\link{Project}} or \code{\link{Scenario}} object}
}
\value{
Invisibly returns \code{TRUE} upon success (i.e.successful 
backup) and \code{FALSE} upon failure.
}
\description{
Backup a \code{\link{SsimLibrary}}. The backup folder can be defined in the
SyncroSim User Interface, but is by default at the same level as the 
SsimLibrary file, and is called libraryName.backup.
}
\examples{
\donttest{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session, SsimLibrary, and Project
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)

# Back up data from the SsimLibrary
backup(myLibrary)
}

}
