% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependency.R
\name{dependency}
\alias{dependency}
\alias{dependency,character-method}
\alias{dependency,Scenario-method}
\title{Set or remove Scenario dependency(s), or get existing dependencies.}
\usage{
dependency(scenario, dependency = NULL, remove = FALSE, force = FALSE)

\S4method{dependency}{character}(scenario, dependency = NULL, remove = FALSE, force = FALSE)

\S4method{dependency}{Scenario}(scenario, dependency = NULL, remove = FALSE, force = FALSE)
}
\arguments{
\item{scenario}{character string, integer, or vector of these. Name or ID of scenario(s) to which a dependency is to be added (or has been already added if remove=TRUE). 
If NULL then ssimObject must be a Scenario. Note that integer ids are slightly faster.}

\item{dependency}{Scenario, character string, integer, or list/vector of these. The scenario(s) that are the source of the dependency, 
in order from lowest to highest precedence. If NULL other arguments are ignored and the list of existing dependencies is returned.}

\item{remove}{logical. If F (default) dependencies are added. If T, dependencies are removed.}

\item{force}{logical. If F (default) prompt before removing dependencies.}
}
\value{
If dependency is NULL, a dataframe of existing dependencies, or list of these if multiple
inputs are provided.
If dependency is not NULL, the function invisibly returns a list bearing the names of the dependencies inputted
and carrying a logical `TRUE` upon success (i.e.successful addition or deletion) and `FALSE` upon failure.
}
\description{
Set or remove Scenario dependency(s), or get existing dependencies.
}
\details{
If dependency==NULL, other arguments are ignored, and set of existing dependencies is returned in order of precedence 
(from highest to lowest precedence).
Otherwise, returns list of saved or error messages for each dependency of each scenario.

Note that the order of dependencies can be important - dependencies added most recently take precedence over existing dependencies.
So, dependencies included in the dependency argument take precedence over any other existing dependencies.
If the dependency argument includes more than one element, elements are ordered from lowest to highest precedence.
}
