% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenario.R
\name{scenario}
\alias{scenario}
\title{Create or open one or more Scenarios.}
\usage{
scenario(
  ssimObject = NULL,
  scenario = NULL,
  sourceScenario = NULL,
  summary = NULL,
  results = FALSE,
  forceElements = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{ssimObject}{SsimLibrary/Project or character. An ssimObject containing a filepath to a library, or a filepath.}

\item{scenario}{Character, integer, or vector of these. Names or ids of one or more scenarios. Note integer ids are slightly faster.}

\item{sourceScenario}{Character or integer. If not NULL, new scenarios will be copies of the sourceScenario.}

\item{summary}{Logical. If TRUE then loads and returns the scenario(s) in a named vector/dataframe with the scenarioId, name, description, owner, dateModified, readOnly, parentID. Default is TRUE if scenario=NULL, FALSE otherwise.}

\item{results}{Logical. If TRUE only return result scenarios.}

\item{forceElements}{Logical. If TRUE then returns a single scenario as a named list; otherwise returns a single scenario as a Scenario object. Applies only when summary=FALSE.}

\item{overwrite}{Logical. If TRUE an existing Scenario will be overwritten.}
}
\value{
A \code{Scenario} object representing a SyncroSim scenario, a list of Scenario objects, or a dataframe of scenario names and descriptions.
If \code{summary} = FALSE, returns one or more \code{\link{Scenario}} objects representing a SyncroSim scenarios.
If \code{summary} = TRUE, returns scenario summary info.
}
\description{
Create or retrievs one or more Scenarios from a library
}
\details{
For each element of scenario:
\itemize{
  \item {If element/project/ssimObject uniquely identifies an existing scenario: }{Returns the existing Scenario}
  \item {If element/project/ssimObject uniquely identifies more than one existing scenario: }{Error}
  \item {If element/project/ssimObject do not identify an existing scenario or project: }{Error}
  \item {If element/project/ssimObject do not identify an existing scenario and element is numeric: }{Error - a name is required for new scenarios. SyncroSim will automatically assign an id when a scenario is created.}
  \item {If element/project/ssimObject do not identify an existing scenario and do identify a project, and element is a character string: }{Creates a new Scenario named element in the project. SyncroSim automatically assigns an id. If sourceScenario is not NULL the new scenario will be a copy of sourceScenario.}
}
}
\examples{
\donttest{
# Create a new scenario
temp_dir <- tempdir()
myses <- session()
myLibrary <- ssimLibrary(name = file.path(temp_dir,"testlib"), session = myses)

myProject <- project(myLibrary, project = "a project")
myScenario <- scenario(myProject, scenario = "a scenario", overwrite = TRUE)
}

}
