% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_districts.R
\name{cg_districts}
\alias{cg_districts}
\title{Get districts for a latitude/longitude or zips}
\usage{
cg_districts(latitude = NULL, longitude = NULL, zip = NULL,
  query = NULL, per_page = 20, page = 1, order = NULL, key = NULL,
  as = "table", ...)
}
\arguments{
\item{latitude}{(numeric) latitude of coordinate}

\item{longitude}{(numeric) longitude of coordinate}

\item{zip}{(integer) A 5 digit zip code}

\item{query}{(character) Return results the API thinks best match your query. Queries are
interpreted as phrases.}

\item{per_page}{Number of records to return. Default: 20. Max: 50.}

\item{page}{Page to return. Default: 1. You can use this in combination with the
per_page parameter to get more than the default or max number of results per page.}

\item{order}{Sort results by one or more fields with the order parameter. order is
optional, but if no order is provided, the order of results is not guaranteed to be predictable.
Append \code{__asc} or \code{__desc} to the field names to control sort direction. The default
direction is \code{desc}, because it is expected most queries will sort by a date. Any field
which can be used for filtering may be used for sorting. On full-text search endpoints (URLs
ending in \code{/search}), you may sort by score to order by relevancy.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{as}{(character) One of table (default), list, or response (httr response object)}

\item{...}{Optional additional curl options (debugging tools mostly). See examples.}
}
\value{
List including data.frame and metadata about results, list, or httr
response object.
}
\description{
Get districts for a latitude/longitude or zips
}
\details{
A zip code may intersect multiple Congressional districts, so it is not as precise as
using a latitude and longitude. In general, we recommend against using zip codes to look up
members of Congress. For one, it's imprecise: a zip code can intersect multiple congressional
districts. More importantly, zip codes are not shapes. They are lines (delivery routes), and
treating them as shapes leads to inaccuracies.
}
\examples{
\dontrun{
cg_districts(zip = 27511)
cg_districts(latitude = 35.778788, longitude = -78.787805)

# most parameters are vectorized, pass in more than one value
cg_districts(zip = c(27511, 97202))
}
}

