% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_igraph.R
\name{as_igraph}
\alias{as_igraph}
\title{as.igraph}
\usage{
as_igraph(x, ...)
}
\arguments{
\item{x}{a similarity object}

\item{...}{further parameters used by \link[igraph:graph_from_adjacency_matrix]{igraph::graph_from_adjacency_matrix}}
}
\value{
an igraph object
}
\description{
Converts a data frame of similarity coefficients into a graph.
}
\examples{
files <- list.files(path=system.file("examples", package="rscc"), pattern="*.R$", full.names = TRUE)
prgs  <- sourcecode(files, basename=TRUE)
coeff <- similarities(prgs)        # variables only
# a similarity coefficients equal to zero does not create an edge!
g <- as_igraph(coeff, diag=FALSE)
# thicker edges have higher similarity coefficients
plot(g, edge.width=1+3*igraph::E(g)$weight)
}
