% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy.R
\name{load_star_database}
\alias{load_star_database}
\title{Load star_database (from a RDS file)}
\usage{
load_star_database(file)
}
\arguments{
\item{file}{A string, name of the file that stores the object.}
}
\value{
A \code{star_database} object.
}
\description{
Load star_database (from a RDS file)
}
\examples{

mrs_rdb_file <- tempfile("mrs", fileext = ".rdb")
mrs_sqlite_file <- tempfile("mrs", fileext = ".sqlite")

mrs_sqlite_connect <- function() {
  DBI::dbConnect(RSQLite::SQLite(),
                 dbname = mrs_sqlite_file)
}

mrs_db <- mrs_db |>
  deploy(
    name = "mrs",
    connect = mrs_sqlite_connect,
    file = mrs_rdb_file
  )

mrs_db2 <- load_star_database(mrs_rdb_file)

}
\seealso{
\code{\link{star_database}}

Other star database deployment functions: 
\code{\link{cancel_deployment}()},
\code{\link{deploy}()},
\code{\link{get_deployment_names}()}
}
\concept{star database deployment functions}
