% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_estimators.R
\name{estimate_param_null}
\alias{estimate_param_null}
\title{Estimation of moments of the data}
\usage{
estimate_param_null(robust2SLS_object)
}
\arguments{
\item{robust2SLS_object}{An object of class \code{"robust2sls"} for which
the moments will be calculated.}
}
\value{
\code{estimate_param_null} returns a list with a similar structure as
the output of the Monte Carlo functionality \link{generate_param}. Hence, the
resulting list can be given to the function \link{gauge_avar} as argument
\code{parameters} to return an estimate of the asymptotic variance of the
gauge.
}
\description{
\code{estimate_param_null} can be used to estimate certain moments of the
data that are required for calculating the asymptotic variance of the gauge.
Such moments are the covariance between the standardised first stage errors
and the structural error \eqn{\Omega}, the covariance matrix of the first
stage errors \eqn{\Sigma}, the first stage parameter matrix \eqn{\Pi}, and
more.
}
\section{Warning}{

The function uses the full sample to estimate the moments. Therefore, they
are only consistent under the null hypothesis of no outliers and estimators
are likely to be inconsistent under the alternative.
}

