% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_goldprice.R
\name{get_goldprice_from}
\alias{get_goldprice_from}
\title{Retrieves the gold price from a specific date.}
\usage{
get_goldprice_from(date)
}
\arguments{
\item{date}{date from which the gold price should
be fetched.}
}
\value{
nbp_api_response object containing the gold price
from the specified date.
}
\description{
Retrieves the gold price from a specific date.
}
\details{
As gold prices are not published on the weekends
fetching values from a weekend date will result in a 404
error. In those cases the function returns an error with an
appropriate message.
}
\examples{

\donttest{
## Fetch the gold price from a week ago
response <- get_goldprice_from(Sys.Date() - 7)

## Preview response content
response$content
}

}
\seealso{
\url{http://api.nbp.pl/#cenyZlota}

Other goldprice: \code{\link{get_current_goldprice}},
  \code{\link{get_goldprice_from_interval}},
  \code{\link{get_last_n_goldprices}},
  \code{\link{get_todays_goldprice}}
}
\concept{goldprice}
