% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inner_lines.R
\name{ms_innerlines}
\alias{ms_innerlines}
\title{Create a line layer consisting of shared boundaries with no attribute data}
\usage{
ms_innerlines(input, force_FC = TRUE, sys = FALSE, sys_mem = 8)
}
\arguments{
\item{input}{input polygons object to convert to inner lines. One of:
\itemize{
\item \code{geo_json} or \code{character} polygons;
\item \code{geo_list} polygons;
\item \code{SpatialPolygons*};
\item \code{sf} or \code{sfc} polygons object
}}

\item{force_FC}{should the output be forced to be a FeatureCollection (or
Spatial*DataFrame) even if there are no attributes? Default \code{TRUE}.
FeatureCollections are more compatible with rgdal::readOGR and
geojsonio::geojson_sp. If FALSE and there are no attributes associated with
the geometries, a GeometryCollection (or Spatial object with no dataframe)
will be output.}

\item{sys}{Should the system mapshaper be used instead of the bundled mapshaper? Gives
better performance on large files. Requires the mapshaper node package to be installed
and on the PATH.}

\item{sys_mem}{How much memory (in GB) should be allocated if using the system
mapshaper (\code{sys = TRUE})? Default 8. Ignored if \code{sys = FALSE}.}
}
\value{
lines in the same class as the input layer, but without attributes
}
\description{
Create a line layer consisting of shared boundaries with no attribute data
}
\examples{
library(geojsonio)
library(sp)

poly <- structure('{"type":"FeatureCollection",
            "features":[
              {"type":"Feature",
                "properties":{"foo": "a"},
                "geometry":{"type":"Polygon","coordinates":[[
                  [102,2],[102,3],[103,3],[103,2],[102,2]
                  ]]}}
              ,{"type":"Feature",
                "properties":{"foo": "a"},
                "geometry":{"type":"Polygon","coordinates":[[
                  [103,3],[104,3],[104,2],[103,2],[103,3]
                  ]]}},
              {"type":"Feature",
                "properties":{"foo": "b"},
                "geometry":{"type":"Polygon","coordinates":[[
                  [102,1],[102,2],[103,2],[103,1],[102,1]
                  ]]}},
              {"type":"Feature",
                "properties":{"foo": "b"},
                "geometry":{"type":"Polygon","coordinates":[[
                  [103,1],[103,2],[104,2],[104,1],[103,1]
                  ]]}}]}', class = c("json", "geo_json"))

poly <- geojson_sp(poly)
plot(poly)

out <- ms_innerlines(poly)
plot(out)

}
