% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{is_call}
\alias{is_call}
\title{Is object a call?}
\usage{
is_call(x, name = NULL, n = NULL, ns = NULL)
}
\arguments{
\item{x}{An object to test. If a formula, the right-hand side is
extracted.}

\item{name}{An optional name that the call should match. It is
passed to \code{\link[=sym]{sym()}} before matching. This argument is vectorised
and you can supply a vector of names to match. In this case,
\code{is_call()} returns \code{TRUE} if at least one name matches.}

\item{n}{An optional number of arguments that the call should
match.}

\item{ns}{The namespace of the call. If \code{NULL}, the namespace
doesn't participate in the pattern-matching. If an empty string
\code{""} and \code{x} is a namespaced call, \code{is_call()} returns
\code{FALSE}. If any other string, \code{is_call()} checks that \code{x} is
namespaced within \code{ns}.

Can be a character vector of namespaces, in which case the call
has to match at least one of them, otherwise \code{is_call()} returns
\code{FALSE}.}
}
\description{
This function tests if \code{x} is a \link[=call2]{call}. This is a
pattern-matching predicate that returns \code{FALSE} if \code{name} and \code{n}
are supplied and the call does not match these properties.
}
\section{Life cycle}{


\code{is_lang()} has been soft-deprecated and renamed to \code{is_call()} in
rlang 0.2.0 and similarly for \code{is_unary_lang()} and
\code{is_binary_lang()}. This renaming follows the general switch from
"language" to "call" in the rlang type nomenclature. See lifecycle
section in \code{\link[=call2]{call2()}}.
}

\examples{
is_call(quote(foo(bar)))

# You can pattern-match the call with additional arguments:
is_call(quote(foo(bar)), "foo")
is_call(quote(foo(bar)), "bar")
is_call(quote(foo(bar)), quote(foo))

# Match the number of arguments with is_call():
is_call(quote(foo(bar)), "foo", 1)
is_call(quote(foo(bar)), "foo", 2)


# By default, namespaced calls are tested unqualified:
ns_expr <- quote(base::list())
is_call(ns_expr, "list")

# You can also specify whether the call shouldn't be namespaced by
# supplying an empty string:
is_call(ns_expr, "list", ns = "")

# Or if it should have a namespace:
is_call(ns_expr, "list", ns = "utils")
is_call(ns_expr, "list", ns = "base")

# You can supply multiple namespaces:
is_call(ns_expr, "list", ns = c("utils", "base"))
is_call(ns_expr, "list", ns = c("utils", "stats"))

# If one of them is "", unnamespaced calls will match as well:
is_call(quote(list()), "list", ns = "base")
is_call(quote(list()), "list", ns = c("base", ""))
is_call(quote(base::list()), "list", ns = c("base", ""))


# The name argument is vectorised so you can supply a list of names
# to match with:
is_call(quote(foo(bar)), c("bar", "baz"))
is_call(quote(foo(bar)), c("bar", "foo"))
is_call(quote(base::list), c("::", ":::", "$", "@"))
}
\seealso{
\code{\link[=is_expression]{is_expression()}}
}
