% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{call_name}
\alias{call_name}
\title{Extract function name of a call}
\usage{
call_name(call)
}
\arguments{
\item{call}{Can be a call or a quosure that wraps a call.}
}
\value{
A string with the function name, or \code{NULL} if the function
is anonymous.
}
\description{
Extract function name of a call
}
\section{Life cycle}{


In rlang 0.2.0, \code{lang_name()} was soft-deprecated and renamed to
\code{call_name()}. See lifecycle section in \code{\link[=call2]{call2()}} for more about this
change.
}

\examples{
# Extract the function name from quoted calls:
call_name(quote(foo(bar)))
call_name(quo(foo(bar)))

# Or from a frame:
foo <- function(bar) call_name(call_frame())
foo(bar)

# Namespaced calls are correctly handled:
call_name(~base::matrix(baz))

# Anonymous and subsetted functions return NULL:
call_name(quote(foo$bar()))
call_name(quote(foo[[bar]]()))
call_name(quote(foo()()))
}
\seealso{
\code{\link[=call_fn]{call_fn()}}
}
