% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_options.R
\name{default_compile_options}
\alias{default_compile_options}
\title{Define a list of default options used for compilation in \code{rkeops} package}
\usage{
default_compile_options()
}
\value{
a list of class \code{rkeops_compile_options} (see
\code{\link[=compile_options]{compile_options()}} for the detailed output).
}
\description{
To compile user-defined operators, \code{rkeops} requires compilation options.

The function \code{default_compile_options} returns a list with default values
for the corresponding options (see Details).
}
\details{
Please refer to \code{\link[=compile_options]{compile_options()}} for a detailed description of
these options.

\strong{Note:} Default options are set up when loading \code{rkeops}. To reset
\code{rkeops} options to default, you should use the function
\code{\link[=set_rkeops_options]{set_rkeops_options()}}. To set up a particular option, you should
use the function \code{\link[=set_rkeops_option]{set_rkeops_option()}}. Some wrappers are available
to enable some compilation options, see \code{\link[=compile4float32]{compile4float32()}},
\code{\link[=compile4float64]{compile4float64()}}, \code{\link[=compile4cpu]{compile4cpu()}},
\code{\link[=compile4gpu]{compile4gpu()}}.
}
\examples{
default_compile_options()
}
\seealso{
\code{\link[=compile_options]{compile_options()}}, \code{\link[=set_rkeops_options]{set_rkeops_options()}},
\code{\link[=set_rkeops_option]{set_rkeops_option()}}, \code{\link[=compile4float32]{compile4float32()}},
\code{\link[=compile4float64]{compile4float64()}}, \code{\link[=compile4cpu]{compile4cpu()}}, \code{\link[=compile4gpu]{compile4gpu()}}
}
\author{
Ghislain Durif
}
