% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfuncs.R
\name{kfunc}
\alias{kfunc}
\title{Plotting K-functions for a Set of Surveys}
\usage{
kfunc(
  seg,
  vert,
  survey = NULL,
  rivers,
  lwd = 2,
  envelope = TRUE,
  envreps = 1000,
  envcol = "grey80",
  envborder = NA,
  maxdist = NULL,
  xlab = "Distance",
  ylab = "\% within",
  showN = TRUE,
  whichplots = NULL,
  returnoutput = FALSE,
  ...
)
}
\arguments{
\item{seg}{A vector of river locations (segment)}

\item{vert}{A vector of river locations (vertex)}

\item{survey}{A vector of survey IDs corresponding to the values of 
\code{seg} and \code{vert}.  Defaults to \code{NULL}.  If this argument is 
used, K-functions will be calculated for each unique survey, and separate 
plots will be produced.}

\item{rivers}{The river network object to use}

\item{lwd}{Line width used for plotting.  Defaults to 2.}

\item{envelope}{Whether to construct and display a 95 percent confidence 
envelope (see note.)  Defaults to \code{TRUE} if \code{survey} is specified, and is automatically \code{FALSE} otherwise.}

\item{envreps}{Number of bootstrap replicates to use for envelope 
calculation.  Defaults to 1000.}

\item{envcol}{Color to use for envelope plotting.  Defaults to 
\code{"grey80"}.}

\item{envborder}{Border color to use for envelope plotting.  Defaults to 
\code{NA}, which will result in no border being plotted.}

\item{maxdist}{Maximum distance (x-axis value) for plotting.  The default 
value (\code{NULL}) will result in an appropriate value being chosen.}

\item{xlab}{X-coordinate label for plotting}

\item{ylab}{Y-coordinate label for plotting}

\item{showN}{Whether to show the sample size for each survey in each plot 
title.  Defaults to \code{TRUE}.}

\item{whichplots}{A vector of plots to produce, if multiple plots are 
produced.  For example, specifying \code{whichplot=c(2,3,4)} will result in
only the second, third, and fourth plots of the sequence being produced. 
Accepting the default (\code{NULL}) will result in all plots being 
produced.}

\item{returnoutput}{Whether to return output instead of producing a plot.  Defaults to \code{FALSE}.}

\item{...}{Additional plotting parameters.}
}
\description{
Plots K-functions for locations in each of a set of surveys.  In
  this implementation, this can be interpreted as the proportion of 
  additional fish within a given distance.  This will increase as a function 
  of distance, and may provide evidence of clustering or dispersion features,
  particularly if the envelope is used.
}
\note{
K-function envelopes for each survey are constructed by bootstrapping 
  all within-survey distances, that is, the distances between all individuals
  within each survey, for all surveys.  This results in a confidence envelope
  under the assumption that spacing is independent of survey; therefore a
  survey K-function outside the envelope provides evidence of clustering or 
  dispersal in that survey that is outside the typical range.  An envelope is not available if only one survey is plotted.
  
  A K-function above the envelope for a given distance range provides
  evidence of a greater number of individuals than expected at that distance
  range (clustering); A K-function below the envelope for a given distance
  range provides evidence of a smaller number of individuals than expected at
  that distance range (dispersal).

This function is distance-computation intensive, and will be extremely slow-running if a river network is used that does not have segment routes and/or distance lookup tables for fast distance computation.  See \link{buildsegroutes} and/or \link{buildlookup} for more information.
}
\examples{
data(Gulk, fakefish)

# # 10 plots will be created - recommend calling
# # par(mfrow=c(3,4))

kfunc(seg=fakefish$seg, vert=fakefish$vert, rivers=Gulk, survey=fakefish$flight,
envreps=100, maxdist=200000)

# # This shows relatively high amounts of clustering for surveys 1 and 8,
# # and relatively high amounts of dispersal in surveys 5 and 6.


# # plotting the survey locations that led to this calculation, for comparison

# # 10 plots will be created - recommend calling
# # par(mfrow=c(3,4))
for(i in 1:10) {
  plot(x=Gulk, segmentnum=FALSE, color=FALSE, main=i)
  riverpoints(seg=fakefish$seg[fakefish$flight==i], 
  vert=fakefish$vert[fakefish$flight==i], rivers=Gulk, col=2, pch=15)
}
}
\author{
Matt Tyers
}
