% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcSeCox.R
\name{calcSeCox}
\alias{calcSeCox}
\title{Computation of standard errors for predictions}
\usage{
calcSeCox(
  object,
  times,
  nTimes,
  type,
  diag,
  Lambda0,
  object.n,
  object.time,
  object.eXb,
  object.strata,
  nStrata,
  new.n,
  new.eXb,
  new.LPdata,
  new.strata,
  new.survival,
  nVar,
  export,
  store.iid
)
}
\arguments{
\item{object}{The fitted Cox regression model object either
obtained with \code{coxph} (survival package) or \code{cph}
(rms package).}

\item{times}{Vector of times at which to return the estimated
hazard/survival.}

\item{nTimes}{the length of the argument \code{times}.}

\item{type}{One or several strings that match (either in lower or upper case or mixtures) one
or several of the strings \code{"hazard"},\code{"cumhazard"}, \code{"survival"}.}

\item{diag}{[logical] when \code{FALSE} the hazard/cumlative hazard/survival for all observations at all times is computed,
otherwise it is only computed for the i-th observation at the i-th time.}

\item{Lambda0}{the baseline hazard estimate returned by \code{BaseHazStrata_cpp}.}

\item{object.n}{the number of observations in the dataset used to estimate the object.}

\item{object.time}{the time to event of the observations used to estimate the object.}

\item{object.eXb}{the exponential of the linear predictor relative to the observations used to estimate the object.}

\item{object.strata}{the strata index of the observations used to estimate the object.}

\item{nStrata}{the number of strata.}

\item{new.n}{the number of observations for which the prediction was performed.}

\item{new.eXb}{the linear predictor evaluated for the new observations.}

\item{new.LPdata}{the variables involved in the linear predictor for the new observations.}

\item{new.strata}{the strata indicator for the new observations.}

\item{new.survival}{the survival evaluated for the new observations.}

\item{nVar}{the number of variables that form the linear predictor.}

\item{export}{can be "iid" to return the value of the influence function for each observation.
"se" to return the standard error for a given timepoint.
"average.iid" to return the value of the average influence function over the observations for which the prediction was performed.}

\item{store.iid}{Implementation used to estimate the influence function and the standard error.
Can be \code{"full"} or \code{"minimal"}. See the details section.}
}
\value{
A list optionally containing the standard error for the survival, cumulative hazard and hazard.
}
\description{
Compute the standard error associated to the predictions from Cox regression model
using a first order von Mises expansion of the functional (cumulative hazard or survival).
}
\details{
\code{store.iid="full"} compute the influence function for each observation at each time in the argument \code{times}
before computing the standard error / influence functions.
\code{store.iid="minimal"} recompute for each subject specific prediction the influence function for the baseline hazard.
This avoid to store all the influence functions but may lead to repeated evaluation of the influence function.
This solution is therefore more efficient in memory usage but may not be in terms of computation time.
}
\author{
Brice Ozenne broz@sund.ku.dk, Thomas A. Gerds tag@biostat.ku.dk
}
