% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttesti.R
\name{ttesti}
\alias{ttesti}
\alias{ttesti.do}
\alias{print.ttesti}
\alias{ttesti.default}
\title{T-test Given Summary Statistics with Improved Layout}
\usage{
ttesti(
  obs,
  mean,
  sd,
  obs2 = NA,
  mean2 = NA,
  sd2 = NA,
  null.hypoth = 0,
  conf.level = 0.95,
  alternative = "two.sided",
  var.eq = FALSE,
  more.digits = 0
)
}
\arguments{
\item{obs}{number of observations for the
first sample.}

\item{mean}{the sample mean of the first
sample.}

\item{sd}{the sample standard deviation of
the first sample.}

\item{obs2}{number of observations for the second sample (this is optional).}

\item{mean2}{if \code{obs2} is supplied, then sample mean of the second
sample must be supplied.}

\item{sd2}{if \code{obs2} is supplied, then sample standard deviation of the
second sample must be supplied.}

\item{null.hypoth}{a number specifying the
null hypothesis for the mean (or difference in means if performing a
two-sample test). Defaults to zero.}

\item{conf.level}{confidence level of the test.
Defaults to 0.95.}

\item{alternative}{a string: one of
\code{"less"}, \code{"two.sided"}, or \code{"greater"} specifying the form
of the test. Defaults to a two-sided test.}

\item{var.eq}{a logical value, either
\code{TRUE} or \code{FALSE} (default), specifying whether or not equal
variances should be presumed in a two-sample t-test.}

\item{more.digits}{a numeric value
specifying whether or not to display more or fewer digits in the output.
Non-integers are automatically rounded down.}
}
\value{
a list of class \code{ttesti}. The print method lays out the information in an easy-to-read
format. 
\item{tab}{A formatted table of descriptive and inferential statistics (number of observations,
mean, standard error of the mean estimate, standard deviation), 
along with a confidence interval for the mean.}
\item{df}{Degrees of freedom for the t-test.}
\item{p}{P-value for the t-test.}
\item{tstat}{Test statistic for the t-test.}
\item{par}{A vector of information about the type of test (null hypothesis, alternative hypothesis, etc.)}
\item{twosamp}{A logical value indicating whether a two-sample test was performed.}
\item{call}{The call made to the \code{ttesti} function.}
}
\description{
Performs a one- or two-sample t-test given summary statistics. 
In the two-sample case, the user can specify
whether or not equal variances should be presumed.
}
\details{
If \code{obs2}, \code{mean2}, or \code{sd2} is specified, then all three must be specified
and a two-sample t-test is run.
}
\examples{

# t-test given sample descriptives
ttesti(24, 175, 35, null.hypoth=230)

# two-sample test
ttesti(10, -1.6, 1.5, 30, -.7, 2.1)

}
