% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_spss.R
\name{read_spss}
\alias{read_spss}
\title{Read SPSS (`.sav`, `.zsav`, `.por`) files. Write `.sav` and `.zsav` files.}
\usage{
read_spss(
  file,
  user_na = TRUE,
  id = NULL,
  filename = NULL,
  doi = NULL,
  .name_repair = "unique"
)
}
\arguments{
\item{file}{An SPSS file.}

\item{user_na}{Should user-defined na_values be imported? Defaults
to \code{TRUE}.}

\item{id}{An identifier of the tibble, if omitted, defaults to the
file name.}

\item{filename}{An import file name.}

\item{doi}{An optional document object identifier.}

\item{.name_repair}{Defaults to \code{"unique"} See 
\code{tibble::\link[tibble:as_tibble]{as_tibble}} for details.}
}
\value{
A tibble, data frame variant with nice defaults.

  Variable labels are stored in the "label" attribute of each variable.
  It is not printed on the console, but the RStudio viewer will show it.

  `write_sav()` returns the input `data` invisibly.
}
\description{
`read_sav()` reads both `.sav` and `.zsav` files; `write_sav()` creates
`.zsav` files when `compress = TRUE`. `read_por()` reads `.por` files.
`read_spss()` uses either `read_por()` or `read_sav()` based on the
file extension.
}
\details{
This is a wrapper around \code{haven::\link[haven:read_spss]{read_spss}}
}
\examples{
\donttest{
path <- system.file("examples", "iris.sav", package = "haven")
haven::read_sav(path)

tmp <- tempfile(fileext = ".sav")
haven::write_sav(mtcars, tmp)
haven::read_sav(tmp)
}
}
\seealso{
Other import functions: 
\code{\link{pull_survey}()},
\code{\link{read_rds}()},
\code{\link{read_surveys}()},
\code{\link{subset_save_surveys}()}
}
\concept{import functions}
