% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_sample.R
\name{report_sample}
\alias{report_sample}
\title{Sample Description}
\usage{
report_sample(
  data,
  group_by = NULL,
  centrality = "mean",
  select = NULL,
  exclude = NULL,
  weights = NULL,
  total = TRUE,
  digits = 2,
  ...
)
}
\arguments{
\item{data}{A data frame for which descriptive statistics should be created.}

\item{group_by}{Character vector, indicating the column for possible grouping
of the descriptive table.}

\item{centrality}{Character, indicates the statistics that should be
calculated for numeric variables. May be \code{"mean"} (for mean and
standard deviation) or \code{"median"} (for median and median absolute
deviation) as summary.}

\item{select}{Character vector, with column names that should be included in
the descriptive table.}

\item{exclude}{Character vector, with column names that should be excluded
from the descriptive table.}

\item{weights}{Character vector, indicating the name of a potential
weight-variable. Reported descriptive statistics will be weighted by
\code{weight}.}

\item{total}{Add a \code{Total} column.}

\item{digits}{Number of decimals.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame of class \code{report_sample} with variable names and
  their related summary statistics.
}
\description{
Create sample description table (also referred to as "Table 1").
}
\examples{
library(report)

report_sample(iris[, 1:4])
report_sample(iris, select = c("Sepal.Length", "Petal.Length", "Species"))
report_sample(iris, group_by = "Species")
}
