% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_refundObj.R
\name{as_refundObj}
\alias{as_refundObj}
\title{Convert data to refund objects for use in functional data analyses}
\usage{
as_refundObj(obj, ...)
}
\arguments{
\item{obj}{Object to be converted. Currently supports class \code{matrix}, formatted
so that rows contain functional observations on subjects.}

\item{...}{additional arguments to be passed to methods.}
}
\value{
An object of classes \code{data.frame} and \code{refund.object}, the latter of
which is so far not used. Columns are \code{id} (taken from the rownames of \code{obj},
if they exist), \code{index} (with behavior described above), and \code{value} (taken
from entries in \code{obj}).
}
\description{
Very experimental function, primarily used to convert matrices storing functional data
to data.frames with specific variable names.
}
\examples{

\dontrun{
library(ggplot2)
library(refund)

cca_df = as_refundObj(DTI$cca)

ggplot(cca_df, aes(x = index, y = value, group = id)) + geom_line()
}

}
\author{
Jeff Goldsmith \email{jeff.goldsmith@columbia.edu}
}

