% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxid.R
\name{taxid}
\alias{taxid}
\title{taxid}
\usage{
taxid(tax_fac)
}
\arguments{
\item{tax_fac}{Output of function \code{tax_fac{}}.}
}
\description{
Generate taxanomic codes for each species by converting species, genus,
family, and subclass into factors
}
\examples{
\dontrun{
# Create Lookup table
Species <- c("tenuifolium", "asterolepis", "simplex var.grandiflora", "simplex var.ochnacea")
Genus <- c("Protium", "Quararibea", "Swartzia", "Swartzia")
Family <- c("Burseraceae", "Bombacaceae", "Fabaceae", "Fabaceae")
Subclass <- c("Sapindales", "Malvales", "Fabales", "Fabales")
lookup <- cbind.data.frame(Species, Genus, Family, Subclass)

tf <- taxfac(lookup)
taxid(tf)
}

}
