% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SemiMarkovModel.R
\docType{class}
\name{SemiMarkovModel}
\alias{SemiMarkovModel}
\title{A semi-Markov model for cohort simulation}
\description{
An R6 class representing a semi-Markov model for 
cohort simulation.
}
\details{
A class to represent a continuous time semi-Markov chain, modelled
using cohort simulation. As interpreted in \pkg{rdecision}, semi-Markov 
models
may include temporary states and transitions are defined by per-cycle
probabilities. Although used widely in health economic modelling, the
differences between semi-Markov models and Markov processes introduce
some caveats for modellers:
\itemize{
\item{If there are temporary states, the result will depend on cycle length.}
\item{Transitions are specified by their conditional probability, which
is a \emph{per-cycle} probability of starting a cycle in one state and
ending it in another; if the cycle length changes, the probabilities should 
change, too.}
\item{Probabilities and rates cannot be linked by the Kolmogorov forward
equation, where the per-cycle probabilities are given by the matrix 
exponential of the transition rate matrix, because this equation does not
apply if there are temporary states. In creating semi-Markov models, it is 
the  modeller's task to estimate probabilities from published data on 
event rates.}
\item{The cycle time cannot be changed during the simulation.}
}
}
\section{Graph theory}{

A Markov model is a directed multidigraph permitting loops (a loop 
multidigraph), optionally labelled, or a \dfn{quiver}. It is a
multidigraph because there are potentially two edges between each pair of
nodes {A,B} representing the transition probabilities from A to B and 
\emph{vice versa}. It is a directed graph because the transition
probabilities refer to transitions in one direction. Each edge can be 
optionally labelled. It permits self-loops (edges whose source and target 
are the same node) to represent patients that remain in the same state 
between cycles.
}

\section{Transition rates and probabilities}{


\subsection{Why semi-Markov?}{
Beck and Pauker (1983) and later Sonnenberg and Beck (1993) proposed the
use of Markov processes to model the health economics of medical 
interventions. Further, they introduced the additional concept of temporary 
states, to which patients who transition remain for exactly one cycle. This
breaks the principle that Markov processes are memoryless
and thus the underlying mathematical formalism, first
developed by Kolmogorov, is not applicable. For example, ensuring that all
patients leave a temporary state requires its transition rate to be infinite.
Hence, such models are usually labelled as semi-Markov processes.
}

\subsection{Rates and probabilities}{
Miller and Homan (1994) and Fleurence & Hollenbeak (2007) provide advice
on estimating probabilities from rates. Jones (2017) and Welton (2005) 
describe methods for estimating probabilities in multi-state, 
multi-transition models, although those methods may not apply to 
semi-Markov models with temporary states. In particular note that the
"simple" equation, \eqn{p = 1-e^{-rt}} (Briggs 2006) applies only in a 
two-state, one transition model.
}

\subsection{Uncertainty in rates}{
In semi-Markov models, the conditional probabilities of the transitions 
from each state are usually modelled by a Dirichlet distribution. In 
\pkg{rdecision}, create a Dirichlet distribution for each state and 
optionally create model variables for each conditional probability 
(\eqn{\rho_{ij}}) linked to an applicable Dirichlet distribution.
}
}

\references{
{
  Beck JR and Pauker SG. The Markov Process in Medical Prognosis. 
  \emph{Med Decision Making}, 1983;\strong{3}:419–458.

  Briggs A, Claxton K, Sculpher M. Decision modelling for health economic 
  evaluation. Oxford, UK: Oxford University Press; 2006.
  
  Fleurence RL and Hollenbeak CS. Rates and probabilities in economic 
  modelling. \emph{PharmacoEconomics}, 2007;\strong{25}:3--6. 
  
  Jones E, Epstein D and García-Mochón L. A procedure for deriving 
  formulas to convert transition rates to probabilities for multistate
  Markov models. \emph{Medical Decision Making} 2017;\strong{37}:779–789.

  Miller DK and Homan SM. Determining transition probabilities: confusion
  and suggestions. \emph{Medical Decision Making} 1994;\strong{14}:52-58. 
  
  Sonnenberg FA, Beck JR. Markov models in medical decision making: a
  practical guide. \emph{Medical Decision Making}, 1993:\strong{13}:322.
  
  Welton NJ and Ades A. Estimation of Markov chain transition probabilities
  and rates from fully and partially observed data: uncertainty
  propagation, evidence synthesis, and model calibration. 
  \emph{Medical Decision Making}, 2005;\strong{25}:633-645.
}
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super classes}{
\code{\link[rdecision:Graph]{rdecision::Graph}} -> \code{\link[rdecision:Digraph]{rdecision::Digraph}} -> \code{SemiMarkovModel}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SemiMarkovModel$new()}}
\item \href{#method-set_probabilities}{\code{SemiMarkovModel$set_probabilities()}}
\item \href{#method-transition_probabilities}{\code{SemiMarkovModel$transition_probabilities()}}
\item \href{#method-transition_cost}{\code{SemiMarkovModel$transition_cost()}}
\item \href{#method-get_statenames}{\code{SemiMarkovModel$get_statenames()}}
\item \href{#method-reset}{\code{SemiMarkovModel$reset()}}
\item \href{#method-get_populations}{\code{SemiMarkovModel$get_populations()}}
\item \href{#method-get_elapsed}{\code{SemiMarkovModel$get_elapsed()}}
\item \href{#method-tabulate_states}{\code{SemiMarkovModel$tabulate_states()}}
\item \href{#method-cycle}{\code{SemiMarkovModel$cycle()}}
\item \href{#method-cycles}{\code{SemiMarkovModel$cycles()}}
\item \href{#method-modvars}{\code{SemiMarkovModel$modvars()}}
\item \href{#method-modvar_table}{\code{SemiMarkovModel$modvar_table()}}
\item \href{#method-clone}{\code{SemiMarkovModel$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="degree">}\href{../../rdecision/html/Graph.html#method-degree}{\code{rdecision::Graph$degree()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="edge_index">}\href{../../rdecision/html/Graph.html#method-edge_index}{\code{rdecision::Graph$edge_index()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="graph_adjacency_matrix">}\href{../../rdecision/html/Graph.html#method-graph_adjacency_matrix}{\code{rdecision::Graph$graph_adjacency_matrix()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="has_edge">}\href{../../rdecision/html/Graph.html#method-has_edge}{\code{rdecision::Graph$has_edge()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="has_vertex">}\href{../../rdecision/html/Graph.html#method-has_vertex}{\code{rdecision::Graph$has_vertex()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="is_simple">}\href{../../rdecision/html/Graph.html#method-is_simple}{\code{rdecision::Graph$is_simple()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="neighbours">}\href{../../rdecision/html/Graph.html#method-neighbours}{\code{rdecision::Graph$neighbours()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="order">}\href{../../rdecision/html/Graph.html#method-order}{\code{rdecision::Graph$order()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="size">}\href{../../rdecision/html/Graph.html#method-size}{\code{rdecision::Graph$size()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Graph" data-id="vertex_index">}\href{../../rdecision/html/Graph.html#method-vertex_index}{\code{rdecision::Graph$vertex_index()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="as_DOT">}\href{../../rdecision/html/Digraph.html#method-as_DOT}{\code{rdecision::Digraph$as_DOT()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="digraph_adjacency_matrix">}\href{../../rdecision/html/Digraph.html#method-digraph_adjacency_matrix}{\code{rdecision::Digraph$digraph_adjacency_matrix()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="digraph_incidence_matrix">}\href{../../rdecision/html/Digraph.html#method-digraph_incidence_matrix}{\code{rdecision::Digraph$digraph_incidence_matrix()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="direct_predecessors">}\href{../../rdecision/html/Digraph.html#method-direct_predecessors}{\code{rdecision::Digraph$direct_predecessors()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="direct_successors">}\href{../../rdecision/html/Digraph.html#method-direct_successors}{\code{rdecision::Digraph$direct_successors()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_acyclic">}\href{../../rdecision/html/Digraph.html#method-is_acyclic}{\code{rdecision::Digraph$is_acyclic()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_arborescence">}\href{../../rdecision/html/Digraph.html#method-is_arborescence}{\code{rdecision::Digraph$is_arborescence()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_connected">}\href{../../rdecision/html/Digraph.html#method-is_connected}{\code{rdecision::Digraph$is_connected()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_polytree">}\href{../../rdecision/html/Digraph.html#method-is_polytree}{\code{rdecision::Digraph$is_polytree()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_tree">}\href{../../rdecision/html/Digraph.html#method-is_tree}{\code{rdecision::Digraph$is_tree()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="is_weakly_connected">}\href{../../rdecision/html/Digraph.html#method-is_weakly_connected}{\code{rdecision::Digraph$is_weakly_connected()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="paths">}\href{../../rdecision/html/Digraph.html#method-paths}{\code{rdecision::Digraph$paths()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="topological_sort">}\href{../../rdecision/html/Digraph.html#method-topological_sort}{\code{rdecision::Digraph$topological_sort()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Digraph" data-id="walk">}\href{../../rdecision/html/Digraph.html#method-walk}{\code{rdecision::Digraph$walk()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a semi-Markov model for cohort simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SemiMarkovModel$new(
  V,
  E,
  tcycle = as.difftime(365.25, units = "days"),
  discount.cost = 0,
  discount.utility = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{V}}{A list of nodes (\code{MarkovState}s).}

\item{\code{E}}{A list of edges (\code{Transition}s).}

\item{\code{tcycle}}{Cycle length, expressed as an R \code{difftime} object.}

\item{\code{discount.cost}}{Annual discount rate for future costs. Note this
is a rate, not a probability (i.e. use 0.035 for 3.5\%).}

\item{\code{discount.utility}}{Annual discount rate for future incremental
utility. Note this is a rate, not a probability (i.e. use 0.035 
for 3.5\%).}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A semi-Markov model must meet the following conditions:
\enumerate{
  \item It must have at least one node and at least one edge.
  \item All nodes must be of class \code{MarkovState};
  \item All edges must be of class \code{Transition};
  \item The nodes and edges must form a digraph whose underlying
  graph is connected;
  \item Each state must have at least one outgoing transition (for 
  absorbing states this is a self-loop);
  \item For each state the sum of outgoing conditional transition 
  probabilities must be one. For convenience, one outgoing transition 
  probability from each state may be set to NA when the 
  probabilities are defined. Typically, probabilities for self 
  loops would be set to NA. Transition probabilities in \eqn{Pt} 
  associated with transitions that are not defined as edges in the 
  graph are zero. Probabilities can be changed between cycles.
  \item No two edges may share the same source and target nodes (i.e. 
  the digraph may not have multiple edges). This is to ensure that there
  are no more transitions than cells in the transition matrix.
  \item The node labels must be unique to the graph.
}
}

\subsection{Returns}{
A \code{SemiMarkovModel} object. The population of the first
state is set to 1000 and from each state there is an equal 
conditional probability of each allowed transition.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_probabilities"></a>}}
\if{latex}{\out{\hypertarget{method-set_probabilities}{}}}
\subsection{Method \code{set_probabilities()}}{
Sets transition probabilities.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SemiMarkovModel$set_probabilities(Pt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Pt}}{Per-cycle transition probability matrix. The row and 
column labels must be the state names and each row must sum to one.
Non-zero probabilities for undefined transitions are not allowed. At
most one \code{NA} may appear in each row. If an NA is present in a row,
it is replaced by 1 minus the sum of the defined probabilities.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Updated \code{SemiMarkovModel} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transition_probabilities"></a>}}
\if{latex}{\out{\hypertarget{method-transition_probabilities}{}}}
\subsection{Method \code{transition_probabilities()}}{
Per-cycle transition probability matrix for the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SemiMarkovModel$transition_probabilities()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A square matrix of size equal to the number of states. If all
states are labelled, the dimnames take the names of the states.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transition_cost"></a>}}
\if{latex}{\out{\hypertarget{method-transition_cost}{}}}
\subsection{Method \code{transition_cost()}}{
Return the per-cycle transition costs for the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SemiMarkovModel$transition_cost()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A square matrix of size equal to the number of states. If all
states are labelled, the dimnames take the names of the states.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_statenames"></a>}}
\if{latex}{\out{\hypertarget{method-get_statenames}{}}}
\subsection{Method \code{get_statenames()}}{
Returns a character list of state names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SemiMarkovModel$get_statenames()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of the names of each state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\if{latex}{\out{\hypertarget{method-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the model counters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SemiMarkovModel$reset(
  populations = NULL,
  icycle = as.integer(0),
  elapsed = as.difftime(0, units = "days")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{populations}}{A named vector of populations for
the start of the state. The names should be the state names. 
Due to the R implementation of matrix algebra, \code{populations} 
must be a numeric type and is not restricted to being an integer. If 
NULL, the population of the first state is set to 1000 and the others
to zero.}

\item{\code{icycle}}{Cycle number at which to start/restart.}

\item{\code{elapsed}}{Elapsed time since the index (reference) time used for
discounting as an R \code{difftime} object.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Resets the state populations, next cycle number and elapsed time
of the model. By default the model is returned to its ground state (1000
people in the first state and zero in the others; next cycle is labelled
zero; elapsed time (years) is zero). Any or all of these can be set via 
this function. \code{icycle} is simply an integer counter label for each 
cycle, \code{elapsed} sets the elapsed time in years from the index time
from which discounting is assumed to apply.
}

\subsection{Returns}{
Updated \code{SemiMarkovModel} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_populations"></a>}}
\if{latex}{\out{\hypertarget{method-get_populations}{}}}
\subsection{Method \code{get_populations()}}{
Gets the occupancy of each state
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SemiMarkovModel$get_populations()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A numeric vector of populations, named with state names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_elapsed"></a>}}
\if{latex}{\out{\hypertarget{method-get_elapsed}{}}}
\subsection{Method \code{get_elapsed()}}{
Gets the current elapsed time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SemiMarkovModel$get_elapsed()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The elapsed time is defined as the difference between the 
current time in the model and an index time used as the reference
time for applying discounting. By default the elapsed time starts at
zero. It can be set directly by calling \code{reset}. It is incremented
after each call to \code{cycle} by the cycle duration to the time at the
end of the cycle (even if half cycle correction is used). Thus, via the
\code{reset} and \code{cycle} methods, the time of each cycle relative 
to the discounting index and its duration can be controlled arbitrarily.
}

\subsection{Returns}{
Elapsed time as an R \code{difftime} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tabulate_states"></a>}}
\if{latex}{\out{\hypertarget{method-tabulate_states}{}}}
\subsection{Method \code{tabulate_states()}}{
Tabulation of states
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SemiMarkovModel$tabulate_states()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Creates a data frame summary of each state in the model.
}

\subsection{Returns}{
A data frame with the following columns:
\describe{
\item{Name}{State name}
\item{Cost}{Annual cost of occupying the state}
\item{Utility}{Incremental utility associated with being in the state.}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cycle"></a>}}
\if{latex}{\out{\hypertarget{method-cycle}{}}}
\subsection{Method \code{cycle()}}{
Applies one cycle of the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SemiMarkovModel$cycle(hcc.pop = TRUE, hcc.cost = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hcc.pop}}{Boolean; whether to apply half cycle correction to the
population and QALY. If TRUE, the correction is only applied to the 
outputs of 
functions \code{cycle} and \code{cycles}; the state population passed to
the next cycle is the end cycle population, obtainable 
with \code{get_populations}.}

\item{\code{hcc.cost}}{Boolean; whether to apply half cycle correction to the
costs. If true, the occupancy costs are computed using the population
at half cycle; if false they are applied at the end of the cycle. 
Applicable only if \code{hcc.pop} is TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Calculated values, one row per state, as a data frame with the
following columns:
\describe{
\item{\code{State}}{Name of the state.}
\item{\code{Cycle}}{The cycle number.}
\item{\code{Time}}{Clock time, years.}
\item{\code{Population}}{Population of the state at the end of 
the cycle, or at mid-cycle if half-cycle correction is applied.}
\item{\code{OccCost}}{Cost of the population occupying the state for 
the cycle. Discount is applied, if the options are set. The costs are
normalized by the model population. The cycle costs are derived from the
annual occupancy costs of the \code{MarkovState}s. Applied to the end
population, i.e. unaffected by half cycle correction, as per 
Briggs \emph{et al}.}
\item{\code{EntryCost}}{Cost of the transitions \emph{into} the state
during the cycle. Discounting is applied, if the option is set. 
The result is normalized by the model population. The cycle costs
are derived from \code{Transition} costs.}
\item{\code{Cost}}{Total cost, normalized by model population.}
\item{\code{QALY}}{Quality adjusted life years gained by occupancy of 
the states during the cycle. Half cycle correction and discounting are 
applied, if these options are set. Normalized by the model population.}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cycles"></a>}}
\if{latex}{\out{\hypertarget{method-cycles}{}}}
\subsection{Method \code{cycles()}}{
Applies multiple cycles of the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SemiMarkovModel$cycles(ncycles = 2, hcc.pop = TRUE, hcc.cost = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ncycles}}{Number of cycles to run; default is 2.}

\item{\code{hcc.pop}}{Boolean; whether to apply half cycle correction to the
population and QALY. If TRUE, the correction is only applied to the 
outputs of functions \code{cycle} and \code{cycles}; the state 
population passed to
the next cycle is the end cycle population, obtainable 
with \code{get_populations}.}

\item{\code{hcc.cost}}{Boolean; whether to apply half cycle correction to the
costs. If true, the occupancy costs are computed using the population
at half cycle; if false they are applied at the end of the cycle.
Applicable only if \code{hcc.pop} is TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The starting populations are redistributed through the
transition probabilities and the state occupancy costs are
calculated, using function \code{cycle}. The end populations are
then fed back into the model for a further cycle and the
process is repeated. For each cycle, the state populations and
the aggregated occupancy costs are saved in one row of the
returned data frame, with the cycle number. If the cycle count
for the model is zero when called, the first cycle reported
will be cycle zero, i.e. the distribution of patients to starting
states.
}

\subsection{Returns}{
Data frame with cycle results, with the following columns:
\describe{
\item{\code{Cycle}}{The cycle number.}
\item{\code{Years}}{Elapsed time at end of cycle, years}
\item{\code{Cost}}{Cost associated with occupancy and transitions between
states during the cycle.}
\item{\code{QALY}}{Quality adjusted life years associated with occupancy
of the states in the cycle.}
\item{\code{<name>}}{Population of state \code{<name>} at the end of
the cycle.}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-modvars"></a>}}
\if{latex}{\out{\hypertarget{method-modvars}{}}}
\subsection{Method \code{modvars()}}{
Find all the model variables in the Markov model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SemiMarkovModel$modvars()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Returns variables of type \code{ModVar} that have been 
specified as values associated with transition rates and costs and
the state occupancy costs and utilities.
}

\subsection{Returns}{
A list of \code{ModVar}s.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-modvar_table"></a>}}
\if{latex}{\out{\hypertarget{method-modvar_table}{}}}
\subsection{Method \code{modvar_table()}}{
Tabulate the model variables in the Markov model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SemiMarkovModel$modvar_table(expressions = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expressions}}{A logical that defines whether expression model
variables should be included in the tabulation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Data frame with one row per model variable, as follows:
\describe{
\item{\code{Description}}{As given at initialization.}
\item{\code{Units}}{Units of the variable.}
\item{\code{Distribution}}{Either the uncertainty distribution, if
it is a regular model variable, or the expression used to create it,
if it is an \code{ExprModVar}.}
\item{\code{Mean}}{Mean; calculated from means of operands if
an expression.}
\item{\code{E}}{Expectation; estimated from random sample if expression, 
mean otherwise.}
\item{\code{SD}}{Standard deviation; estimated from random sample if
expression, exact value otherwise.}
\item{\code{Q2.5}}{p=0.025 quantile; estimated from random sample if
expression, exact value otherwise.}
\item{\code{Q97.5}}{p=0.975 quantile; estimated from random sample if
expression, exact value otherwise.}
\item{\code{Est}}{TRUE if the quantiles and SD have been estimated by 
random sampling.}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SemiMarkovModel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
