% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcosmo.R
\docType{package}
\name{rcosmo}
\alias{rcosmo}
\alias{rcosmo-package}
\title{Handling and Analysing CMB data}
\description{
Handling and Analysing Spherical, Healpix and Cosmic Microwave Background
data on a HEALPix grid.
}
\details{
The package \code{\link{rcosmo}} offers various tools for
\itemize{
\item{Downloading and transforming Cosmic Microwave Background
radiation (CMB) and spherical data}
\item{Working with Hierarchical Equal Area
isoLatitude Pixelation of a sphere (Healpix)}
\item{Spherical geometry}
\item{Statistical analysis of CMB and spherical data}
\item{Visualisation of Healpix data}
}

Most of \code{\link{rcosmo}} features were developed for CMB,
but it can also be used for other spherical data. It contains
tools for transforming spherical data in cartesian and geographic
coordinates to the Healpix representation.
}
\section{Update}{
 Current updates are available through
URL: https://github.com/VidaliLama/rcosmo
}

\section{BugReports}{
 https://github.com/VidaliLama/rcosmo/issues
}

\author{
Daniel Fryer \email{d.fryer@latrobe.edu.au},
Andriy Olenko \email{a.olenko@latrobe.edu.au}, Ming Li \email{Ming.Li@latrobe.edu.au},
Yuguang Wang.
}
