% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPDataFrame.R
\name{plot.HPDataFrame}
\alias{plot.HPDataFrame}
\title{Plot HPDataFrame}
\usage{
\method{plot}{HPDataFrame}(x, intensities = "I", add = FALSE,
  sample.size, type = "p", size = 1, box = FALSE, axes = FALSE,
  aspect = FALSE, col = "blue", back.col = "black", labels,
  hp.boundaries = 0, hpb.col = "gray", ...)
}
\arguments{
\item{x}{A HPDataFrame.}

\item{intensities}{The column name for the data in \code{x}
that is to be treated
as intensities for plotting.}

\item{add}{if TRUE then this plot will be added to any existing plot.
Note that if \code{back.col} (see below) is specified then a new plot
window will be opened and \code{add = TRUE} will have no effect}

\item{sample.size}{optionally specifies the size of a simple random
sample to take before plotting. This can make the plot less
computationally intensive}

\item{type}{a single character indicating the type of item to plot.
Supported types are: 'p' for points, 's' for spheres, 'l' for lines,
'h' for line segments from z = 0, and 'n' for nothing.}

\item{size}{the size of plotted points}

\item{box}{whether to draw a box}

\item{axes}{whether to draw axes}

\item{aspect}{either a logical indicating whether to adjust the
aspect ratio, or a new ratio.}

\item{col}{specify the colour(s) of the plotted points}

\item{back.col}{optionally specifies the background colour of
the plot. This argument is passed to rgl::bg3d.}

\item{labels}{optionally specify a vector of labels to plot,
such as words or vertex indices. If this is specified then
\code{rgl::text3d} is used instead of \code{rgl::plot3d}. Then
\code{length(labels)} must equal \code{nrow(x)}}

\item{hp.boundaries}{integer. If greater than 0 then HEALPix
pixel boundaries at \code{nside = hp.boundaries} will be
added to the plot}

\item{hpb.col}{colour for the \code{hp.boundaries}}

\item{...}{arguments passed to rgl::plot3d}
}
\value{
A plot of the data locations
according to coordinate columns or HEALPix index
}
\description{
This function produces a plot from a \code{\link{HPDataFrame}}.
If columns x,y,z (cartesian) or theta,phi (colatitude and longitude
respectively) are present in \code{x}, then
these will be used as coordinates for plotting. Otherwise, the
HEALPix indices as in \code{pix(x)} will be used. If HEALPix
indices are used and multiple rows correspond to a single pixel
index, then beware that values may be obfuscated in the plot,
and all locations are pixel centers.
}
\examples{
hpdf <- HPDataFrame(I = rep(0,12), nside = 1)
plot(hpdf, size = 5, col = "yellow", back.col = "black",
     hp.boundaries = 1)

}
