% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{cone_mesh}
\alias{cone_mesh}
\title{Cone 3D Model}
\usage{
cone_mesh(
  start = c(0, 0, 0),
  end = c(0, 1, 0),
  radius = 0.5,
  direction = NA,
  from_center = FALSE,
  material = material_list()
)
}
\arguments{
\item{start}{Default `c(0, 0, 0)`. Base of the cone, specifying `x`, `y`, `z`.}

\item{end}{Default `c(0, 1, 0)`. Tip of the cone, specifying `x`, `y`, `z`.}

\item{radius}{Default `1`. Radius of the bottom of the cone.}

\item{direction}{Default `NA`. Alternative to `start` and `end`, specify the direction (via 
a length-3 vector) of the cone. Cone will be centered at `start`, and the length will be
determined by the magnitude of the direction vector.}

\item{from_center}{Default `TRUE`. If orientation specified via `direction`, setting this argument
to `FALSE` will make `start` specify the bottom of the cone, instead of the middle.}

\item{material}{Default `material_list()` (default values). Specify the material of the object.}
}
\value{
List describing the mesh.
}
\description{
Cone 3D Model
}
\examples{
\dontshow{
options("cores"=1)
}
#Generate a cone
\donttest{
generate_cornell_mesh() \%>\%
  add_shape(cone_mesh(start = c(555/2, 20, 555/2), end = c(555/2, 300, 555/2),
                      radius = 100)) \%>\%
  rasterize_scene(light_info = directional_light(c(0.5,0.5,-1)))
}

#Generate a blue cone with a wide base
\donttest{
generate_cornell_mesh() \%>\%
  add_shape(cone_mesh(start = c(555/2, 20, 555/2), end = c(555/2, 300, 555/2), radius=200,
                      material = material_list(diffuse="dodgerblue"))) \%>\%
  rasterize_scene(light_info = directional_light(c(0.5,0.5,-1)))
}

#Generate a long, thin cone
\donttest{
generate_cornell_mesh() \%>\%
  add_shape(cone_mesh(start = c(555/2, 20, 555/2), end = c(555/2, 400, 555/2), radius=50,
                      material = material_list(diffuse="dodgerblue"))) \%>\%
  rasterize_scene(light_info = directional_light(c(0.5,0.5,-1)))
}
}
