% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdm_extract_data.R
\name{sdm_extract_data}
\alias{sdm_extract_data}
\title{Spatial Join of Points with Raster Grids}
\usage{
sdm_extract_data(pts, x)
}
\arguments{
\item{pts}{a two-column data frame or matrix with the x and y coordinates of
the locations of interest.}

\item{x}{a raster matrix of class 'asc' (this and the adehabitat package),
'RasterLayer' (raster package) or 'SpatialGridDataFrame' (sp package)}
}
\value{
Returns a vector equal in length to the number of locations in pnts.
}
\description{
Spatial Join of Points with Raster Grids
}
\details{
\code{sdm_extract_data} is an adaptation of \code{extract.data} from
SDMTools; extracts data from raster object of class 'asc' or
RasterLayer' (raster package) at specified locations.
}
\examples{
\dontrun{
#create a simple object of class 'asc'
tasc = as.asc(matrix(1:50,nr=50,nc=50)); print(tasc)

#define some point locations
points = data.frame(x=runif(25,1,50),y=runif(25,1,50))

#extract the data
points$values = sdm_extract_data(points, tasc)

#show the data
print(points)
}
}
\author{
Gopi Goteti
}
