% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.R
\name{write.coeff}
\alias{write.coeff}
\title{Write coefficient table for linear and logistic regression}
\usage{
write.coeff(object, file = "", sort = FALSE)
}
\arguments{
\item{object}{A fitted model object of class regress or logistic}

\item{file}{A character string naming a file. "" indicates output to the console}

\item{sort}{Sort table by variable importance}
}
\description{
Write coefficient table for linear and logistic regression
}
\details{
Write coefficients and importance scores to csv
}
\examples{
regress(diamonds, rvar = "price", evar = "carat:x", check = "standardize") \%>\%
  write.coeff(sort = TRUE) \%>\%
  formatdf(dec = 3)

}
