% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goodness.R
\name{goodness}
\alias{goodness}
\title{Evaluate if sample data for a categorical variable is consistent wtih a hypothesized distribution}
\usage{
goodness(dataset, var, p = NULL, data_filter = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{var}{A categorical variable}

\item{p}{Hypothesized distribution as a number, fraction, or numeric vector. If unspecified, defaults to an even distribution}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list of all variables used in goodness as an object of class goodness
}
\description{
Evaluate if sample data for a categorical variable is consistent wtih a hypothesized distribution
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/goodness.html} for an example in Radiant
}
\examples{
result <- goodness("newspaper", "Income")

}
\seealso{
\code{\link{summary.goodness}} to summarize results

\code{\link{plot.goodness}} to plot results
}

