% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{not_equal_to}
\alias{not_equal_to}
\alias{!=.torch.Tensor}
\title{Compare two tensors if not equal}
\usage{
\method{!=}{torch.Tensor}(a, b)
}
\arguments{
\item{a}{tensor}

\item{b}{tensor}
}
\value{
A tensor of booleans, where False corresponds to 0, and 1 to True
in a tensor of data type \code{torch$bool}.
}
\description{
This generic is approximately similar to \code{torch$ne(a, b)}, with the
difference that the generic returns a tensor of booleans instead of
a tensor of data type \code{torch$uint8}.
}
\examples{
\donttest{
a <- torch$Tensor(list(1, 1, 1))
b <- torch$Tensor(list(2, 2, 2))
a != b
}
}
