% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nass_api.R
\name{search_data_items}
\alias{search_data_items}
\title{Get available data items based on search terms.}
\usage{
search_data_items(key, search_terms, exclude = c())
}
\arguments{
\item{key}{Your NASS api key.}

\item{search_terms}{A vector of search terms. Each result will include all
terms.}

\item{exclude}{A vector of search terms to exclude. No result will have any
of these.}
}
\value{
A list of all search results.
}
\description{
There are large number of data items available. This function can be used
to increasingly refine search results until the desired data item is found.
}
\examples{
\donttest{
key <- Sys.getenv('NASS_KEY')
search_data_items(key, search_terms=c('corn', 'harvested'),
                  exclude=c('sweet'))
search_data_items(key, search_terms=c('corn', 'price'), exclude=c())
}
}
