% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{meta}
\alias{meta}
\alias{meta<-}
\title{Get or set object metadata}
\usage{
meta(x, field = NULL, type = c("user", "object", "system", "all"))

meta(x, field = NULL) <- value
}
\arguments{
\item{x}{an object for which the metadata will be read or set}

\item{field}{metadata field name(s); if \code{NULL} (default), return all
metadata names}

\item{type}{\code{"user"} for user-provided corpus-level metadata;
\code{"system"} for metadata set automatically when the corpus is created;
or \code{"all"} for all metadata.}

\item{value}{new value of the metadata field}
}
\value{
For \code{meta}, a named list of the metadata fields in the corpus.

For \verb{meta <-}, the corpus with the updated user-level metadata.  Only
user-level metadata may be assigned.
}
\description{
Get or set the object metadata in a \link{corpus}, \link{tokens}, \link{dfm}, or
\link{dictionary} object. With the exception of dictionaries, this will be
corpus-level metadata.
}
\examples{
meta(data_corpus_inaugural)
meta(data_corpus_inaugural, "source")
meta(data_corpus_inaugural, "citation") <- "Presidential Speeches Online Project (2014)."
meta(data_corpus_inaugural, "citation")
}
\keyword{corpus}
