% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{meta_system}
\alias{meta_system}
\alias{meta_system<-}
\alias{meta_system<-.corpus}
\alias{meta_system<-.tokens}
\alias{meta_system<-.dfm}
\alias{meta_system<-.dictionary}
\alias{meta_system_defaults}
\title{Internal function to get, set or initialize system metadata}
\usage{
meta_system(x, field = NULL)

meta_system(x, field = NULL) <- value

\method{meta_system}{corpus}(x, field = NULL) <- value

\method{meta_system}{tokens}(x, field = NULL) <- value

\method{meta_system}{dfm}(x, field = NULL) <- value

\method{meta_system}{dictionary}(x, field = NULL) <- value

meta_system_defaults()
}
\arguments{
\item{x}{an object for which the metadata will be read or set}

\item{field}{metadata field name(s); if \code{NULL} (default), return all
metadata names}

\item{value}{new value of the metadata field}

\item{source}{character; the input object class}
}
\value{
\code{meta_system} returns a list with the object's system metadata.
It is literally a wrapper to \code{\link[=meta]{meta(x, field, type = "system")()}}.

\verb{meta_system<-} returns the object with the system metadata
modified. This is an internal function and not designed for users!

\code{meta_system_defaults} returns a list of default system
values, with the user setting the "source" value.  This should be used
to set initial system meta information.
}
\description{
Sets or initializes system metadata for new objects.
}
\examples{
corp <- corpus(c(d1 = "one two three", d2 = "two three four"))
# quanteda:::`meta_system<-`(corp, value = quanteda:::meta_system_defaults("example"))
quanteda:::meta_system(corp)
}
\keyword{internal}
