# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Set a calendar
#'
#' This function sets a calendar to the given market or country convention.
#' Note that at present only the default \sQuote{TARGET} and \sQuote{UnitedStates}
#' are supported.
#'
#' @title Set a calendar
#' @param calstr A character variable containing the market for which a calendar
#' is to be set
#' @return Nothing is returned but the global state is changed
#' @examples
#' setCalendar("UnitedStates")
setCalendar <- function(calstr) {
    invisible(.Call(`_qlcal_setCalendar`, calstr))
}

#' Get calendar name or id
#'
#' This function returns the corresponding (full) name (as in the underlying
#' implementationclass) or identification string (used to select it) of the
#' current calendar.
#'
#' @title Get calendar name, or id
#' @return A string with the calendar name
#' @examples
#' getName()
getName <- function() {
    .Call(`_qlcal_getName`)
}

#' @rdname getName
getId <- function() {
    .Call(`_qlcal_getId`)
}

#' Advance a date to the next business day plus an optional shift
#'
#' This function takes a given date and advances it to the next business day
#' under the current (global) calendar setting. If an optional offset value is
#' given it is applied as well.
#'
#' @title Advance a date
#' @param rd A Date object describing the date to be advanced to the
#' next business day.
#' @param days An optional integer offset applied to the date
#' @param unit An optional character value denoting a time unit, default value
#' is \dQuote{Day}, and supported values are \dQuote{Days}, \dQuote{Weeks},
#' \dQuote{Months}, \dQuote{Years}, \dQuote{Hours}, \dQuote{Seconds},
#' \dQuote{Minutes}, \dQuote{Milliseconds}, \dQuote{Microseconds}.
#' @param bdc An optional integer defining a business day convention, default
#' is \dQuote{Following}, and supported values are
#' \dQuote{Following}, \dQuote{ModifiedFollowing}, \dQuote{Preceding},
#' \dQuote{ModifiedPreceding}, \dQuote{Unadjusted},
#' \dQuote{HalfMonthModifiedFollowing} and \dQuote{Nearest}.
#' @param eom An optional boolean toggle whether end-of-month is to be respected
#' @return The advanced date is returned
#' @examples
#' advanceDate(Sys.Date(), 2)  # today to the next biz day, plus 2 days
#' @seealso The \code{advanceUnits} functions offers the same functionality from R.
advanceDate <- function(rd, days = 0L, unit = "Days", bdc = "Following", eom = FALSE) {
    .Call(`_qlcal_advanceDate`, rd, days, unit, bdc, eom)
}

#' Test a vector of dates for business day
#'
#' This function takes a vector of dates and returns a logical vector
#' of the same length indicating at each position whether the corresponding
#' date is a business day in the currently active (global) calendar.
#'
#' @title Test for business days
#' @param dates A Date vector with dates to be examined
#' @return A logical vector indicating which dates are business days
#' @examples
#' isBusinessDay(Sys.Date()+0:6)
isBusinessDay <- function(dates) {
    .Call(`_qlcal_isBusinessDay`, dates)
}

#' Test a vector of dates for holiday
#'
#' This function takes a vector of dates and returns a logical vector
#' of the same length indicating at each position whether the corresponding
#' date is a holiday in the currently active (global) calendar.
#'
#' @title Test for holidays
#' @param dates A Date vector with dates to be examined
#' @return A logical vector indicating which dates are holidays
#' @examples
#' isHoliday(Sys.Date()+0:6)
isHoliday <- function(dates) {
    .Call(`_qlcal_isHoliday`, dates)
}

#' Test a vector of dates for weekends
#'
#' This function takes a vector of dates and returns a logical vector
#' of the same length indicating at each position whether the corresponding
#' date is a weekend in the currently active (global) calendar.
#'
#' @title Test for weekends
#' @param dates A Date vector with dates to be examined
#' @return A logical vector indicating which dates are weekends
#' @examples
#' isWeekend(Sys.Date()+0:6)
isWeekend <- function(dates) {
    .Call(`_qlcal_isWeekend`, dates)
}

#' Test a vector of dates for end-of-month
#'
#' This function takes a vector of dates and returns a logical vector
#' of the same length indicating at each position whether the corresponding
#' date is at the end of a month in the currently active (global) calendar.
#'
#' @title Test for end-of-month
#' @param dates A Date vector with dates to be examined
#' @return A logical vector indicating which dates are end-of-month
#' @examples
#' isEndOfMonth(Sys.Date()+0:6)
isEndOfMonth <- function(dates) {
    .Call(`_qlcal_isEndOfMonth`, dates)
}

#' Compute a vector of dates with end-of-month
#'
#' This function takes a vector of dates and returns another vector of dates
#' of the same length returning at each position whether the corresponding
#' end-of-month date in the currently active (global) calendar.
#'
#' @title Compute end-of-month
#' @param dates A Date vector with dates
#' @return A Date vector with dates which are end-of-month
#' @examples
#' getEndOfMonth(Sys.Date()+0:6)
getEndOfMonth <- function(dates) {
    .Call(`_qlcal_getEndOfMonth`, dates)
}

#' @rdname adjust
adjust_cpp <- function(dates, bdc = 0L) {
    .Call(`_qlcal_adjust_cpp`, dates, bdc)
}

#' @rdname advanceUnits
advanceUnits_cpp <- function(dates, n, unit, bdc, emr) {
    .Call(`_qlcal_advanceUnits_cpp`, dates, n, unit, bdc, emr)
}

#' Compute the number of business days between dates
#'
#' This function takes two vectors of start and end dates and returns another
#' vector of the number of business days between each corresponding date pair
#' according to the active calendar.
#'
#' @title Compute number of business dates between calendar dates
#' @param from A Date vector with interval start dates
#' @param to A Date vector with interval end dates
#' @param includeFirst A boolean indicating if the start date is included, default
#' is \sQuote{TRUE}
#' @param includeLast A boolean indicating if the end date is included, default
#' is \sQuote{FALSE}
#' @return A numeric vector with the number of business dates between the
#' corresponding date pair
#' @examples
#' businessDaysBetween(Sys.Date() + 0:6, Sys.Date() + 3 + 0:6)
businessDaysBetween <- function(from, to, includeFirst = TRUE, includeLast = FALSE) {
    .Call(`_qlcal_businessDaysBetween`, from, to, includeFirst, includeLast)
}

#' Compute the number of holidays (or business days) between two dates
#'
#' This function takes a start and end date and returns a vector of holidays
#' (or business days) between them according to the active calendar.
#'
#' @title Compute holidays or business days
#' @param from A Date object with the start date
#' @param to A Date object with the end date
#' @param includeWeekends A boolean indicating if weekends should be included, default
#' is \sQuote{FALSE}
#' @return A Date vector with holidays or business days between the given dates
#' @examples
#' getHolidays(Sys.Date(), Sys.Date() + 30)
getHolidays <- function(from, to, includeWeekends = FALSE) {
    .Call(`_qlcal_getHolidays`, from, to, includeWeekends)
}

#' @rdname getHolidays
getBusinessDays <- function(from, to) {
    .Call(`_qlcal_getBusinessDays`, from, to)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_qlcal_RcppExport_registerCCallable', PACKAGE = 'qlcal')
})
