% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qad.R
\name{qad_distribution}
\alias{qad_distribution}
\alias{pqad}
\alias{qqad}
\title{Distribution of qad (H0: independence)}
\usage{
pqad(q, n)

qqad(p, n)
}
\arguments{
\item{q}{vector of quantiles.}

\item{n}{number of observations.}

\item{p}{vector of probabilities.}
}
\value{
\code{pqad} gives the distribution function, i.e. P(qad <= q). \code{qqad} gives the quantile function.
The length of the result is determined by the length of q or p, respectively.
}
\description{
Distribution function - P_H0(qad <= q) - and quantile function for the qad distribution with regard
to the null hypthesis (H0) stating independence between X and Y.
}
\details{
The distribution of qad was computed in the setting of independence
between the random variables X and Y in the following way:

For n < 1000, Monte Carlo (MC) simulation of H0 with 20.000 repetitions were executed
for each sample size. According to these values the empirical cumulative distribution
functions and the quantile functions were computed and then approximated on a coarser grid.

For n >= 1000, MC simulations were executed again, but this time on a coarser sample size grid (steps of 100) until the size of 10.000.
The so obtained quantiles were approximated using the parametric function a*n^b+c, whereby
the parameters a,b,c were estimated using the R-function nls. Using the so calculated quantiles,
the empirical distribution function and the quantile functions were approximated.
}
\examples{
pqad(0.3, 45)
qqad(0.5, 30)
}
