% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qad.R
\name{pairwise.qad}
\alias{pairwise.qad}
\title{Pairwise quantification of (asymmetric and directed) dependencies}
\usage{
pairwise.qad(
  data_df,
  resolution = NULL,
  remove.00 = FALSE,
  min.res = 3,
  permutation = FALSE,
  nperm = 1000,
  DoParallel = FALSE,
  registerC = registerDoParallel,
  ncores = NULL
)
}
\arguments{
\item{data_df}{a data frame containing numeric columns with the observations of the sample.}

\item{resolution}{an integer indicating the number of strips for the checkerboard aggregation (see \link{emp_c_copula}()).
Default (NULL) uses the optimal resolution, computed out of the sample size.}

\item{remove.00}{a logical indicating whether double 0 entries should be excluded (default = FALSE)}

\item{min.res}{an integer indicating the necessary minimum resolution of the checkerboard grid to compute qad, otherwise the result is NA (default = 3).}

\item{permutation}{a logical indicating whether a p-value (based on permutations) is computed; (otherwise the p-value is computed by MC-simulation - see pqad()).}

\item{nperm}{an integer indicating the number of permutation runs.}

\item{DoParallel}{a logical value indicating whether the permutation test is computed parallelized.}

\item{registerC}{function to register the parallel backend. It is recommended to use registerDoParallel() of the doParallel package (default). Other option is for example on a linux based system to install the
doMC package and use registerDoMC}

\item{ncores}{an integer indicating the number of cores used for parallelization. Default (NULL) uses the maximum number of cores minus 1.}
}
\value{
a list, containing 8 data.frames with the dependence measures, corresponding p.values, the resolution of the checkerboard aggregation and the number of removed double zero entries (only if remove.00 = TRUE).
The output of pairwise.qad() can be illustrated using the function \code{heatmap.qad()}.
}
\description{
Pairwise computation of the function \code{qad}(). \code{qad}() is applied on each pair of variables of a numeric data.frame.
}
\examples{
n <- 100
x <- runif(n, 0, 1)
y <- runif(n, 0, 1)
z <- runif(n, 0, 1)
sample_df <- data.frame(x,y,z)

#qad
model <- pairwise.qad(sample_df, permutation = FALSE)
heatmap.qad(model, select = "dependence", fontsize = 5, significance = TRUE, sign.level = 0.05)
}
