% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qad.R
\name{cci}
\alias{cci}
\title{Conditional confidence interval}
\usage{
cci(n, alternative = c("one.sided", "two.sided"))
}
\arguments{
\item{n}{an integer indicating the sample size.}

\item{alternative}{character string specifying the type of the confidence interval; must be one of "one.sided" (default) or "two.sided".}
}
\value{
a named vector indicating the lower and upper boundary of the confidence interval.
}
\description{
Conditioned on the sample size n, approximated confidence intervals of the dependence measure qad(x,y) for independent random variables are computed.
\code{cci()} can be used to test two random variables for independence.
}
\details{
\code{alternative = "one.sided"} provides a one-sided confidence interval, which can be interpreted that
in 95 of 100 realizations of two independet random variables X and Y
the calculated dependence measure qad(x,y) is less than the upper interval boundary.
If \code{alternative = "two.sided"} 95 of 100 realizations lie in between the interval boundaries.
}
