% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateParams.R
\name{estimateParams}
\alias{estimateParams}
\title{Estimated pulse model parameters!}
\usage{
estimateParams(labexon, totexon, totintr, TimeGrid, tL,
  clusterNumber = NULL, loopnumber = 50, message = TRUE)
}
\arguments{
\item{labexon}{A matrix containing expression levels of 4su exons.For the calculation of the expression value, see \code{\link{estimateExpression}}}

\item{totexon}{A matrix containing expression levels of total exons.For the calculation of the expression value, see \code{\link{estimateExpression}}}

\item{totintr}{A matrix containing expression levels of total introns.For the calculation of the expression value, see \code{\link{estimateExpression}}}

\item{TimeGrid}{A vector of points in time at which experimental data is collected, not allowed to be repeated}

\item{tL}{4sU labeled time during the experiment}

\item{clusterNumber}{Given the number of cluster cores, the default is the maximum number of available cores}

\item{loopnumber}{The number of iterations of the gradient descent when solving the parameter. The default is 50.}

\item{message}{Whether to print the log, the default is TRUE}
}
\value{
A 'pulseTDmodel' containing the expression values of the filtered genes, a list of solved parameters, and some basic parameter information
}
\description{
It is used to estimate pulse model parameters.
Transcription rates, processing rates, and degradation correspond to different pulse model parameters, respectively.
The transcription rate has 6 parameters, the processing rate has 5 parameters, and the degradation rate has 4 parameters.
}
\examples{
data('rpkmSim', package='pulseTD')
rpkm_TL <- rpkmSim$labexon[1:2,]
rpkm_PT <- rpkmSim$totintr[1:2,]
rpkm_TT <- rpkmSim$totexon[1:2,]
TimeGrid <- c(0, 15, 30, 45, 60, 75, 90, 105, 120, 135, 150, 165, 180)
tL <- 10
\donttest{
pulseRates<- estimateParams(rpkm_TL,rpkm_TT,rpkm_PT,TimeGrid,tL,clusterNumber=1,loopnumber=10)
}

}
