% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{arctic_2019}
\alias{arctic_2019}
\title{NOAA's Arctic Sea Daily Ice Extend Data}
\format{
A data frame with 13391 rows and 6 variables:
\describe{
\item{Year}{Years of available data (1978--2019).}
\item{Month}{Month (01--12).}
\item{Day}{Day of the month indicated in Column Month.}
\item{Extent}{Daily ice extent, to three decimal places.}
\item{Missing}{Whether a day is missing (1) or not (0)).}
\item{Source Data}{data source in NOAA database.}
}
}
\source{
\url{https://nsidc.org/data/G02135/versions/3}
}
\usage{
arctic_2019
}
\description{
A data set containing the daily ice extent at Arctic Sea from 1978 to 2019,
collected by National Oceanic and Atmospheric Administration (NOAA)
}
\examples{
library(dplyr)
library(lubridate)
library(ggplot2)

data(arctic_2019)

# Create day in the year column to replace Month and Day
north <-
  arctic_2019 \%>\%
  mutate(yday = yday(make_date(Year, Month, Day)),
         .keep = "all") \%>\%
  select(Year, yday, Extent)

ggplot(north) +
  geom_linerange(aes(x = yday, ymin = Year - 0.2, ymax = Year + 0.2),
                 size = 0.5, color = "red") +
  scale_y_continuous(breaks = seq(1980, 2020, by = 5),
                     minor_breaks = NULL) +
  labs(x = "Day",
       y = "Year",
       title = "Measurement frequencies were not always the same")
}
\keyword{datasets}
