% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{cosm_sum}
\alias{cosm_sum}
\title{Cosmetics for summary tables
Adds some cosmetics to tables of descriptive statistics generated by tbl_summary.}
\usage{
cosm_sum(gt_tbl, pad = 3, bold = FALSE, head_label = "**Variable**")
}
\arguments{
\item{gt_tbl}{A table object generated by \code{\link[gtsummary]{tbl_summary}}.}

\item{pad}{Numerical, padding above and bellow rows.}

\item{bold}{Display labels in bold?}

\item{head_label}{Character, label to be used as head for the variable's column.}
}
\value{
A \code{\link[huxtable]{huxtable}}.
}
\description{
Cosmetics for summary tables
Adds some cosmetics to tables of descriptive statistics generated by tbl_summary.
}
\details{
Function \code{cosm_sum} adds some cosmetics to tables generated by \code{\link[gtsummary]{tbl_summary}}, then converts the table as a \code{\link[huxtable]{huxtable}} and sets proper alignment.
}
\examples{
require(dplyr, quietly = TRUE)

data(Oncho)
Oncho \%>\%
  select(-id) \%>\%
  tbl_summary() \%>\%
  cosm_sum(bold = TRUE) \%>\%
  theme_pubh(1)
}
