% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{bland_altman}
\alias{bland_altman}
\title{Bland-Altman agreement plots.}
\usage{
bland_altman(formula, data, transform = FALSE, aspect = 3/4, ...)
}
\arguments{
\item{formula}{A formula of the form y ~ x (see details).}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{transform}{Logical, should ratios instead of difference be used to construct the plot?}

\item{aspect}{Physical aspect ratio passed to \link{xyplot}.}

\item{...}{Further arguments passed to \link{xyplot}.}
}
\description{
Bland-Altman agreement plots.
}
\details{
\code{bland_altman} constructs Bland-Altman agreement plots.

Variables in \code{formula} are continuous paired observations. When the distribution of the outcome
is not normal, but becomes normal with a log-transformation, \code{bland_altman} can plot the ratio between
outcomes (difference in the log scale) by using option \code{transform = TRUE}.
}
\examples{
data(wright, package = "ISwR")
bland_altman(mini.wright ~ std.wright, data = wright, pch = 16)
bland_altman(mini.wright ~ std.wright, data = wright, pch = 16,
             ylab = "Large-mini expiratory flow rate (l/min)",
             xlab = "Mean expiratory flow rate (l/min)")
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.

Deepayan Sarkar, R-Core.
}
