% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go.R
\name{get.go}
\alias{get.go}
\title{Get Gene Ontology Annotation}
\usage{
get.go(id, format = 'dataframe', silent = FALSE)
}
\arguments{
\item{id}{the UniProt identifier of the protein of interest.}

\item{format}{string indicating the output's format. It should be either 'dataframe' or 'string'. The 'string' format may be convenient when subsequent GO terms enrichment analysis is intended.}

\item{silent}{logical, if FALSE print details of the reading process.}
}
\value{
Returns a dataframe (by default) with GO IDs linked to the protein of interest, as well as additional information related to these GO ids. A string with the GO ids can be obtained as output if indicated by means of the argument 'format'.
}
\description{
Gets the gene ontology annotations for a given protein.
}
\examples{
\dontrun{get.go('P01009')}
}
\references{
Rhee et al. (2008) Nature Reviews Genetics 9:509–515.
}
\seealso{
search.go, term.go(), bg.go(), hdfisher.go(), gorilla(), net.go()
}
\author{
Juan Carlos Aledo
}
