% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pssmooth.R
\name{plotMCEPcurve}
\alias{plotMCEPcurve}
\title{Plotting of the Estimated Marginal Causal Effect Predictiveness Curve}
\usage{
plotMCEPcurve(object, confLevel = 0.95, hingePoint = NULL, xLab = NULL)
}
\arguments{
\item{object}{an object returned by \code{\link{summary.riskCurve}}}

\item{confLevel}{the confidence level (0.95 by default) of pointwise and simultaneous confidence intervals}

\item{hingePoint}{the hinge point estimate (\code{NULL} by default)}

\item{xLab}{a character string specifying the x-axis label (\code{NULL} by default)}
}
\value{
None. The function is called solely for plot generation.
}
\description{
Plots point estimates and, if available, pointwise and simultaneous Wald-type bootstrap confidence intervals for the specified marginal causal effect predictiveness (mCEP)
curve.
}
\examples{
n <- 500
Z <- rep(0:1, each=n/2)
S <- MASS::mvrnorm(n, mu=c(2,2,3), Sigma=matrix(c(1,0.9,0.7,0.9,1,0.7,0.7,0.7,1), nrow=3))
p <- pnorm(drop(cbind(1,Z,(1-Z)*S[,2],Z*S[,3]) \%*\% c(-1.2,0.2,-0.02,-0.2)))
Y <- sapply(p, function(risk){ rbinom(1,1,risk) })
X <- rbinom(n,1,0.5)
# delete S(1) in placebo recipients
S[Z==0,3] <- NA
# delete S(0) in treatment recipients
S[Z==1,2] <- NA
# generate the indicator of being sampled into the phase 2 subset
phase2 <- rbinom(n,1,0.3)
# delete Sb, S(0) and S(1) in controls not included in the phase 2 subset
S[Y==0 & phase2==0,] <- c(NA,NA,NA)
# delete Sb in cases not included in the phase 2 subset
S[Y==1 & phase2==0,1] <- NA
data <- data.frame(X,Z,S[,1],ifelse(Z==0,S[,2],S[,3]),Y)
colnames(data) <- c("X","Z","Sb","S","Y")
qS <- quantile(data$S, probs=c(0.05,0.95), na.rm=TRUE)
grid <- seq(qS[1], qS[2], length.out=3)
\donttest{
out <- riskCurve(formula=Y ~ S + factor(X), bsm="Sb", tx="Z", data=data, biomarkerGrid=grid)
boot <- bootRiskCurve(formula=Y ~ S + factor(X), bsm="Sb", tx="Z", data=data,
                      biomarkerGrid=grid, iter=2, seed=10)
sout <- summary(out, boot, contrast="te")
plotMCEPcurve(sout)
}

}
\seealso{
\code{\link{riskCurve}}, \code{\link{bootRiskCurve}} and \code{\link{summary.riskCurve}}
}
