% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psfmi_D3.R
\name{psfmi_D3}
\alias{psfmi_D3}
\title{Meng & Rubin pooling method called by psfmi_lr}
\usage{
psfmi_D3(data, nimp, impvar, Outcome, P, p.crit, print.method)
}
\arguments{
\item{data}{Data frame or data matrix with stacked multiple imputed datasets.
The original dataset that contains missing values must be excluded from the dataset.}

\item{nimp}{A numerical scalar. Number of imputed datasets. Default is 5.}

\item{impvar}{A character vector. Name of the variable that distinguishes the imputed datasets.}

\item{Outcome}{Character vector containing the name of the outcome variable.}

\item{P}{Character vector with the names of the predictor variables.
At least one predictor variable has to be defined.}

\item{p.crit}{A numerical scalar. P-value selection criterium.}

\item{print.method}{logical vector. If TRUE full matrix with p-values of all variables according to
chosen method (under method) is shown. If FALSE (default) p-value for categorical variables according
to method are shown and for continuous and dichotomous predictors Rubin’s Rules are used}
}
\description{
\code{psfmi_D3} Function to pool using Meng & Rubin pooling method
}
\examples{
 psfmi_D3(data=lbpmilr, nimp=5, impvar="Impnr",
 P=c("Gender", "Smoking", "Function", "JobControl"), 
 Outcome="Chronic", print.method = FALSE)

}
