% Generated by roxygen2 (4.0.1): do not edit by hand
\name{protcheck}
\alias{protcheck}
\title{Check if the protein sequence's amino acid types are in the 20 default types}
\usage{
protcheck(x)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}
}
\value{
Logical. \code{TRUE} if all of the amino acid types of the sequence
        are within the 20 default types.
}
\description{
Check if the protein sequence's amino acid types are in the 20 default types
}
\details{
This function checks if the protein sequence's amino acid types are in the 20.
}
\examples{
x = readFASTA(system.file('protseq/P00750.fasta', package = 'protr'))[[1]]
protcheck(x) # TRUE
protcheck(paste(x, 'Z', sep = '')) # FALSE
}
\author{
Nan Xiao <\url{http://r2s.name}>
}
\keyword{acid}
\keyword{amino}
\keyword{check}
\keyword{protein}
\keyword{sequence}
\keyword{type}

