% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trendFit.R
\name{trend}
\alias{trend}
\title{Define a trend component.}
\usage{
trend(var, tempRE = FALSE, type = "smooth", by = NA, k = -1,
  fx = FALSE)
}
\arguments{
\item{var}{A numeric time variable over which a trend or index will be computed.}

\item{tempRE}{If TRUE, this will set up random time effects. The random effects will be constructed by converting the
var argument to a factor. Note that this yields a random effect level for each unique value in var.
If this is not appropriate, an alternative is to set tempRE to false and manually add temporal random
effects in the trend formula (using s(..., bs = "re")). Temporal random effects cannot be used with
index estimation.}

\item{type}{The type of trend to be estimated. One of "smooth", "loglinear" or "index".}

\item{by}{Currently ignored.}

\item{k}{The dimension of the basis for the cubic regression spline of smooth trend fits.}

\item{fx}{If true, automatic selection of degrees of freedom are used for smooth trends.}
}
\value{
A list containing information to set up the trend.
}
\description{
The function is used to set up the trend component used in ptrend formulas.
}
\details{
The function extracts information about the trend component of a formula supplied to ptrend. 
It returns a list containing variable names, information, and \code{\link[mgcv]{s}} components as strings used in subsequent calls to gam.
}
\examples{
## Simulate a data set with 15 sites and 25 years
data = simTrend(15, 25)
## Fit a smooth trend with fixed site effects, but no random time effects,
## and fixed degrees of freedom
trFit = ptrend(count ~ trend(year, tempRE = FALSE, k =  8, fx = FALSE, type = "smooth") +
                 site, data = data)
plot(trFit)
}
\author{
Jonas Knape
}

