% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_rocci.R
\docType{data}
\name{StatRocci}
\alias{StatRocci}
\alias{stat_rocci}
\title{Calculate confidence regions for the empirical ROC curve}
\format{An object of class \code{StatRocci} (inherits from \code{Stat}, \code{ggproto}) of length 5.}
\usage{
StatRocci

stat_rocci(mapping = NULL, data = NULL, geom = "rocci",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  ci.at = NULL, sig.level = 0.05, na.rm = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{ci.at}{Vector of cutoffs at which to display confidence regions. If
NULL, will automatically choose 3 evenly spaced points to display the regions}

\item{sig.level}{Significance level for the confidence regions}

\item{na.rm}{Remove missing observations}

\item{...}{other arguments passed on to \code{\link{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link{layer}} for more details.}
}
\description{
Confidence intervals for TPF and FPF are calculated using the exact 
  method of Clopper and Pearson (1934) each at the level \code{1 - sqrt(1 - 
  alpha)}. Based on result 2.4 from Pepe (2003), the cross-product of these 
  intervals yields a 1 - alpha % confidence region for (FPF, TPF).
}
\section{Aesthetics}{
 
\code{stat_rocci} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
  \item \strong{\code{m}} The continuous biomarker/predictor
  \item \strong{\code{d}} The binary outcome, if not coded as 0/1, the 
  smallest level in sort order is assumed to be 0, with a warning
  \item \code{alpha}
  \item \code{color}
  \item \code{fill}
  \item \code{linetype}
  \item \code{size}
}
}

\section{Computed variables}{

\describe{
  \item{FPF}{estimate of false positive fraction}
  \item{TPF}{estimate of true positive fraction}
  \item{cutoffs}{values of m at which estimates are calculated}
  \item{FPFL}{lower bound of confidence region for FPF}
  \item{FPFU}{upper bound of confidence region for FPF}
  \item{TPFL}{lower bound of confidence region for TPF}
  \item{TPFU}{upper bound of confidence region for TPF}
}
}
\examples{
D.ex <- rbinom(250, 1, .5)
rocdata <- data.frame(D = c(D.ex, D.ex), 
                   M = c(rnorm(250, mean = D.ex, sd = .4), rnorm(250, mean = D.ex, sd = 1)), 
                   Z = c(rep("A", 250), rep("B", 250)))

ggplot(rocdata, aes(m = M, d = D)) + geom_roc() + stat_rocci()
ggplot(rocdata, aes(m = M, d = D)) + geom_roc() + 
stat_rocci(ci.at = quantile(rocdata$M, c(.1, .3, .5, .7, .9)))

}
\references{
\itemize{
\item Clopper, C. J., and Egon S. Pearson. "The use of confidence or fiducial limits illustrated in the case of the binomial." Biometrika (1934): 404-413.
\item Pepe, M.S. "The Statistical Evaluation of Medical Tests for Classification and Prediction." Oxford (2003). 
}
}
\keyword{datasets}

