% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_plm.R, R/tool_methods.R
\name{plm}
\alias{plm}
\alias{terms.panelmodel}
\alias{vcov.panelmodel}
\alias{fitted.panelmodel}
\alias{residuals.panelmodel}
\alias{df.residual.panelmodel}
\alias{coef.panelmodel}
\alias{print.panelmodel}
\alias{update.panelmodel}
\alias{deviance.panelmodel}
\alias{predict.plm}
\alias{formula.plm}
\alias{plot.plm}
\alias{residuals.plm}
\alias{fitted.plm}
\title{Panel Data Estimators}
\usage{
plm(formula, data, subset, weights, na.action, effect = c("individual",
  "time", "twoways", "nested"), model = c("within", "random", "ht", "between",
  "pooling", "fd"), random.method = NULL, random.models = NULL,
  random.dfcor = NULL, inst.method = c("bvk", "baltagi", "am", "bms"),
  restrict.matrix = NULL, restrict.rhs = NULL, index = NULL, ...)

\method{terms}{panelmodel}(x, ...)

\method{vcov}{panelmodel}(object, ...)

\method{fitted}{panelmodel}(object, ...)

\method{residuals}{panelmodel}(object, ...)

\method{df.residual}{panelmodel}(object, ...)

\method{coef}{panelmodel}(object, ...)

\method{print}{panelmodel}(x, digits = max(3, getOption("digits") - 2),
  width = getOption("width"), ...)

\method{update}{panelmodel}(object, formula., ..., evaluate = TRUE)

\method{deviance}{panelmodel}(object, model = NULL, ...)

\method{predict}{plm}(object, newdata = NULL, ...)

\method{formula}{plm}(x, ...)

\method{plot}{plm}(x, dx = 0.2, N = NULL, seed = 1, within = TRUE,
  pooling = TRUE, between = FALSE, random = FALSE, ...)

\method{residuals}{plm}(object, model = NULL, effect = NULL, ...)

\method{fitted}{plm}(object, model = NULL, effect = NULL, ...)
}
\arguments{
\item{formula}{a symbolic description for the model to be
estimated,}

\item{data}{a \code{data.frame},}

\item{subset}{see \code{\link[stats:lm]{stats::lm()}},}

\item{weights}{see \code{\link[stats:lm]{stats::lm()}},}

\item{na.action}{see \code{\link[stats:lm]{stats::lm()}}; currently, not fully
supported,}

\item{effect}{the effects introduced in the model, one of
\code{"individual"}, \code{"time"}, \code{"twoways"}, or
\code{"nested"},}

\item{model}{one of \code{"pooling"}, \code{"within"},
\code{"between"}, \code{"random"} \code{"fd"}, or \code{"ht"},}

\item{random.method}{method of estimation for the variance
components in the random effects model, one of \code{"swar"}
(default), \code{"amemiya"}, \code{"walhus"}, or
\code{"nerlove"},}

\item{random.models}{an alternative to the previous argument, the
models used to compute the variance components estimations are
indicated,}

\item{random.dfcor}{a numeric vector of length 2 indicating which
degree of freedom should be used,}

\item{inst.method}{the instrumental variable transformation: one of
\code{"bvk"}, \code{"baltagi"}, \code{"am"}, or \code{"bms"}
(see also Details),}

\item{restrict.matrix}{a matrix which defines linear restrictions
on the coefficients,}

\item{restrict.rhs}{the right hand side vector of the linear
restrictions on the coefficients,}

\item{index}{the indexes,}

\item{\dots}{further arguments.}

\item{x, object}{an object of class \code{"plm"},}

\item{digits}{number of digits for printed output,}

\item{width}{the maximum length of the lines in the printed output,}

\item{formula.}{a new formula for the update method,}

\item{evaluate}{a boolean for the update method, if \code{TRUE} the
updated model is returned, if \code{FALSE} the call is returned,}

\item{newdata}{the new data set for the \code{predict} method,}

\item{dx}{the half--length of the individual lines for the plot
method (relative to x range),}

\item{N}{the number of individual to plot,}

\item{seed}{the seed which will lead to individual selection,}

\item{within}{if \code{TRUE}, the within model is plotted,}

\item{pooling}{if \code{TRUE}, the pooling model is plotted,}

\item{between}{if \code{TRUE}, the between model is plotted,}

\item{random}{if \code{TRUE}, the random effect model is plotted,}
}
\value{
An object of class \code{"plm"}.

A \code{"plm"} object has the following elements :

\item{coefficients}{the vector of coefficients,}
\item{vcov}{the variance--covariance matrix of the coefficients,}
\item{residuals}{the vector of residuals (these are the residuals
of the (quasi-)demeaned model),}
\item{weights}{(only for weighted estimations) weights as
specified,}
\item{df.residual}{degrees of freedom of the residuals,}
\item{formula}{an object of class \code{"pFormula"} describing the model,}
\item{model}{the model frame as a \code{"pdata.frame"} containing the
variables used for estimation: the response is in first column followed by
the other variables, the individual and time indexes are in the 'index'
attribute of \code{model},}
\item{ercomp}{an object of class \code{"ercomp"} providing the
estimation of the components of the errors (for random effects
models only),}
\item{aliased}{named logical vector indicating any aliased
coefficients which are silently dropped by \code{plm} due to
linearly dependent terms (see also \code{\link[=detect.lindep]{detect.lindep()}}),}
\item{call}{the call.}

It has \code{print}, \code{summary} and \code{print.summary} methods. The
\code{summary} method creates an object of class \code{"summary.plm"} that
extends the object it is run on with information about (inter alia) F
statistic and (adjusted) R-squared of model, standard errors, t--values, and
p--values of coefficients, (if supplied) the furnished vcov, see
\code{\link[=summary.plm]{summary.plm()}} for further details.
}
\description{
Linear models for panel data estimated using the \code{lm} function on
transformed data.
}
\details{
\code{plm} is a general function for the estimation of linear panel
models.  It supports the following estimation methods: pooled OLS
(\code{model = "pooling"}), fixed effects (\code{"within"}), random effects
(\code{"random"}), first--differences (\code{"fd"}), and between
(\code{"between"}). It supports unbalanced panels and two--way effects
(although not with all methods).

For random effects models, four estimators of the transformation
parameter are available by setting \code{random.method} to one of
\code{"swar"} \insertCite{SWAM:AROR:72}{plm} (default), \code{"amemiya"}
\insertCite{AMEM:71}{plm}, \code{"walhus"}
\insertCite{WALL:HUSS:69}{plm}, or \code{"nerlove"}
\insertCite{NERLO:71}{plm}.

For first--difference models, the intercept is maintained (which
from a specification viewpoint amounts to allowing for a trend in
the levels model). The user can exclude it from the estimated
specification the usual way by adding \code{"-1"} to the model formula.

Instrumental variables estimation is obtained using two--part
formulas, the second part indicating the instrumental variables
used. This can be a complete list of instrumental variables or an
update of the first part. If, for example, the model is \code{y ~ x1 + x2 + x3}, with \code{x1} and \code{x2} endogenous and \code{z1} and \code{z2} external
instruments, the model can be estimated with:

\itemize{
\item \code{formula = y~x1+x2+x3 | x3+z1+z2},
\item \code{formula = y~x1+x2+x3 | . -x1-x2+z1+z2}.
}

If an instrument variable estimation is requested, argument
\code{inst.method} selects the instrument variable transformation
method:
\itemize{
\item \code{"bvk"} (default) for \insertCite{BALE:VARA:87;textual}{plm},
\item \code{"baltagi"} for \insertCite{BALT:81;textual}{plm},
\item \code{"am"} for \insertCite{AMEM:MACU:86;textual}{plm},
\item \code{"bms"} for \insertCite{BREU:MIZO:SCHM:89;textual}{plm}.
}

The Hausman--Taylor estimator \insertCite{HAUS:TAYL:81}{plm} is
computed with arguments \code{random.method = "ht"}, \code{model = "random"}, \code{inst.method = "baltagi"} (the other way with only
\code{model = "ht"} is deprecated).
}
\examples{

data("Produc", package = "plm")
zz <- plm(log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp,
          data = Produc, index = c("state","year"))
summary(zz)

# replicates some results from Baltagi (2013), table 3.1
data("Grunfeld", package = "plm")
p <- plm(inv ~ value + capital,
         data = Grunfeld, model = "pooling")

wi <- plm(inv ~ value + capital,
          data = Grunfeld, model = "within", effect = "twoways")

swar <- plm(inv ~ value + capital,
            data = Grunfeld, model = "random", effect = "twoways")

amemiya <- plm(inv ~ value + capital,
               data = Grunfeld, model = "random", random.method = "amemiya",
               effect = "twoways")

walhus <- plm(inv ~ value + capital,
              data = Grunfeld, model = "random", random.method = "walhus",
              effect = "twoways")

# summary and summary with a funished vcov (passed as matrix, 
# as function, and as function with additional argument)
summary(wi)
summary(wi, vcov = vcovHC(wi))
summary(wi, vcov = vcovHC)
summary(wi, vcov = function(x) vcovHC(x, method = "white2"))


# nested random effect model
# replicate Baltagi/Song/Jung (2001), p. 378 (table 6), columns SA, WH
# == Baltagi (2013), pp. 204-205
data("Produc", package = "plm")
pProduc <- pdata.frame(Produc, index = c("state", "year", "region"))
form <- log(gsp) ~ log(pc) + log(emp) + log(hwy) + log(water) + log(util) + unemp
summary(plm(form, data = pProduc, model = "random", effect = "nested"))
summary(plm(form, data = pProduc, model = "random", effect = "nested",
            random.method = "walhus"))

## Hausman-Taylor estimator and Amemiya-MaCurdy estimator
## replicate Baltagi (2005, 2013), table 7.4
data("Wages", package = "plm")
ht <- plm(lwage ~ wks + south + smsa + married + exp + I(exp ^ 2) + 
              bluecol + ind + union + sex + black + ed |
              bluecol + south + smsa + ind + sex + black |
              wks + married + union + exp + I(exp ^ 2), 
          data = Wages, index = 595,
          random.method = "ht", model = "random", inst.method = "baltagi")
summary(ht)

am <- plm(lwage ~ wks + south + smsa + married + exp + I(exp ^ 2) + 
              bluecol + ind + union + sex + black + ed |
              bluecol + south + smsa + ind + sex + black |
              wks + married + union + exp + I(exp ^ 2), 
          data = Wages, index = 595,
          random.method = "ht", model = "random", inst.method = "am")
summary(am)

}
\references{
\insertRef{AMEM:71}{plm}

\insertRef{AMEM:MACU:86}{plm}

\insertRef{BALE:VARA:87}{plm}

\insertRef{BALT:81}{plm}

\insertRef{BALT:SONG:JUNG:01}{plm}

\insertRef{BALT:13}{plm}

\insertRef{BREU:MIZO:SCHM:89}{plm}

\insertRef{HAUS:TAYL:81}{plm}

\insertRef{NERLO:71}{plm}

\insertRef{SWAM:AROR:72}{plm}

\insertRef{WALL:HUSS:69}{plm}
}
\seealso{
\code{\link[=summary.plm]{summary.plm()}} for further details about the associated
summary method and the "summary.plm" object both of which provide some model
tests and tests of coefficients.  \code{\link[=fixef]{fixef()}} to compute the fixed
effects for "within" models (=fixed effects models).
}
\author{
Yves Croissant
}
\keyword{regression}
