% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_serial.R
\name{pbltest}
\alias{pbltest}
\alias{pbltest.formula}
\alias{pbltest.plm}
\title{Baltagi and Li Serial Dependence Test For Random Effects Models}
\usage{
pbltest(x, ...)

\method{pbltest}{formula}(x, data, alternative = c("twosided", "onesided"),
  index = NULL, ...)

\method{pbltest}{plm}(x, alternative = c("twosided", "onesided"), ...)
}
\arguments{
\item{x}{a model formula or an estimated random--effects model of
class \code{plm} ,}

\item{\dots}{further arguments.}

\item{data}{for the formula interface only: a \code{data.frame},}

\item{alternative}{one of \code{"twosided"},
\code{"onesided"}. Selects either \eqn{H_A: \rho \neq 0} or
\eqn{H_A: \rho = 0} (i.e., the Normal or the Chi-squared
version of the test),}

\item{index}{the index of the \code{data.frame},}
}
\value{
An object of class \code{"htest"}.
}
\description{
\insertCite{BALT:LI:95;textual}{plm}'s Lagrange multiplier test for
AR(1) or MA(1) idiosyncratic errors in panel models with random
effects.
}
\details{
This is a Lagrange multiplier test for the null of no serial
correlation, against the alternative of either an AR(1) or an MA(1)
process, in the idiosyncratic component of the error term in a
random effects panel model (as the analytical expression of the
test turns out to be the same under both alternatives,
\insertCite{@see @BALT:LI:95 and @BALT:LI:97}{plm}. The
\code{alternative} argument, defaulting to \code{twosided}, allows testing
for positive serial correlation only, if set to \code{onesided}.
}
\examples{

data("Grunfeld", package = "plm")

# formula interface
pbltest(inv ~ value + capital, data = Grunfeld)

# plm interface
re_mod <- plm(inv ~ value + capital, data = Grunfeld, model = "random")
pbltest(re_mod)
pbltest(re_mod, alternative = "onesided")

}
\references{
\insertRef{BALT:LI:95}{plm}

\insertRef{BALT:LI:97}{plm}
}
\seealso{
\code{\link[=pdwtest]{pdwtest()}}, \code{bgtest},
\code{\link[=pbsytest]{pbsytest()}}, \code{\link[=pwartest]{pwartest()}} and
\code{\link[=pwfdtest]{pwfdtest()}} for other serial correlation tests for
panel models.
}
\author{
Giovanni Millo
}
\keyword{htest}
