% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m325nhl.R
\name{m325nhl}
\alias{m325nhl}
\title{Minenergo-325. Normative heat losses of pipe}
\usage{
m325nhl(
  year = 1986,
  laying = "underground",
  exp5k = TRUE,
  insulation = 0,
  d = 700,
  temperature = 110,
  len = 1,
  duration = 1,
  beta = FALSE,
  extra = 2
)
}
\arguments{
\item{year}{year when the pipe is put in operation after laying or total overhaul.
Type: \code{\link{assert_integerish}}}

\item{laying}{type of pipe laying depicting the position of pipe in space:
\itemize{
  \item \code{air},
  \item \code{channel},
  \item \code{room},
  \item \code{tunnel},
  \item \code{underground}.
}
Type: \code{\link{assert_subset}}.}

\item{exp5k}{pipe regime flag: is pipe operated more that 5000 hours per year?
Type: \code{\link{assert_logical}}.}

\item{insulation}{insulation that covers the exterior of pipe:
\describe{
  \item{\code{0}}{no insulation}
  \item{\code{1}}{foamed polyurethane or analogue}
  \item{\code{2}}{polymer concrete}
}
Type: \code{\link{assert_integer}} and \code{\link{assert_subset}}.}

\item{d}{internal diameter of pipe, [\emph{mm}]. Type: \code{\link{assert_double}}.}

\item{temperature}{temperature of heat carrier (water) inside the pipe, [\emph{°C}].
Type: \code{\link{assert_double}}.}

\item{len}{length of pipe, [\emph{m}]. Type: \code{\link{assert_double}}.}

\item{duration}{duration of heat flux emittance, [\emph{hour}]. Type: \code{\link{assert_double}}.}

\item{beta}{should they consider additional heat losses of fittings?
Type: \code{\link{assert_logical}}.}

\item{extra}{number of points used for temperature extrapolation: \code{2}, \code{3},
or \code{4}. Type: \code{\link{assert_choice}}.}
}
\value{
Heat flux emitted by pipe during \code{duration}, [\emph{kcal}].
 If \code{len} of pipe is 1 \emph{m} and \code{duration} of heat flux
 emittance is set to 1 \emph{hour} then the return value is in the same
 units as value of heat flux, [\emph{kcal/m/h}], accepted by
 \href{http://docs.cntd.ru/document/902148459}{Minenergo Order 325}.
 Type: \code{\link{assert_double}}.
}
\description{
Calculate normative values of heat flux that is legally affirmed by
 \href{http://docs.cntd.ru/document/902148459}{Minenergo Order 325} to be
 emitted by steel pipe of district heating system with water as a heat carrier.
}
\details{
Temperature extrapolation and pipe diameter interpolation are leveraged
 for better accuracy. Both are linear as it dictated by
 \href{http://docs.cntd.ru/document/902148459}{Minenergo Order 325}.
 Nevertheless, one could control the extrapolation behavior by \code{extra}
 argument: use lower values of \code{extra} for soft curvature near extrapolation
 edges, and higher values for more physically reasoned behavior in far regions
 of extrapolation.
}
\examples{

 with(m325nhldata, {

 ## Linear extrapolation adopted in Minenergo's Order 325 using last two points:
 temperature <- seq(0, 270, 10)  # [°C]
 flux <- m325nhl(1980, "underground", TRUE, 0, 73, temperature)  # [kcal/m/h]
 plot(temperature, flux, type = "b")

 ## Consider heat losses of fittings:
 stopifnot(
   ## when beta becomes 1.15
   all(
     round(
       m325nhl(1980, "underground", d = 73, temperature = 65,
               beta = c(FALSE, TRUE)),
       3
     ) == c(65.500, 75.325)
   ),

   ## when beta becomes 1.2
   all(
     round(
       m325nhl(2000, "channel", d = 73, temperature = 65,
               beta = c(FALSE, TRUE)),
       3
     ) == c(17.533, 21.040)
   )
 )
})


}
\seealso{
Other Minenergo: 
\code{\link{m278hlair}()},
\code{\link{m278hlcha}()},
\code{\link{m278hlund}()},
\code{\link{m278insdata}},
\code{\link{m278inshcm}()},
\code{\link{m278soildata}},
\code{\link{m325beta}()},
\code{\link{m325dropt}()},
\code{\link{m325nhldata}},
\code{\link{m325testbench}}
}
\concept{Minenergo}
