% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m278inshcm.R
\name{m278inshcm}
\alias{m278inshcm}
\title{Minenergo-278. Thermal conductivity of pipe insulation materials}
\usage{
m278inshcm(temperature = 110, material = "aerocrete")
}
\arguments{
\item{temperature}{temperature of heat carrier (water) inside the pipe, [\emph{°C}].
Type: \code{\link{assert_double}}.}

\item{material}{designation of insulation material as it stated in \code{\link{m278insdata}},
Type: \code{\link{assert_subset}}.}
}
\value{
Thermal conductivity of insulation materials [\emph{W/m/°C}] at given
 set of temperatures. Type: \code{\link{assert_double}}.
}
\description{
Get normative values of thermal conductivity of pipe insulation
 materials affirmed by
 \href{http://www.complexdoc.ru/ntdtext/547103/}{Minenergo Method 278} as
 a function of temperature of heat carrier (water).
}
\examples{

# Averaged thermal conductivity of pipe insulation at 110 °C
print(m278insdata)
head(m278inshcm(110, m278insdata[["material"]]))
# [1] 0.09600 0.07525 0.14950 0.14325 0.14950 0.10800

# Terms for linear connection between thermal conductivity of unknown
# (averaged) pipe insulator vs temperature:
temperature <- as.double(1:450)
lambda_ins <- with(m278insdata, {
  vapply(temperature, function(x) mean(m278inshcm(x, material)), .1)
})
C <- coef(lsfit(temperature, lambda_ins))  # c(Intercept, X)
stopifnot(
  all(abs(C - c(7.963590e-02, 9.730769e-05)) < 1e-8)
)

}
\seealso{
Other Minenergo: 
\code{\link{m278hlair}()},
\code{\link{m278hlcha}()},
\code{\link{m278hlund}()},
\code{\link{m278insdata}},
\code{\link{m278soildata}},
\code{\link{m325beta}()},
\code{\link{m325dropt}()},
\code{\link{m325nhldata}},
\code{\link{m325nhl}()},
\code{\link{m325testbench}}
}
\concept{Minenergo}
